<!-- ...................................................................... -->
<!-- XHTML 1.0 Table Module  .............................................. -->
<!-- file: XHTML1-tables.mod

     This is XHTML 1.0, an XML reformulation of HTML 4.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)XHTML1-tables.mod 1.1 99/03/16 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.0 HTML 4.0 and 3.2 Tables//EN"
     SYSTEM "XHTML1-tables.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- d6. HTML 3.2 and HTML 4.0 Tables 

     The HTML 3.2 and 4.0 table models are based on a subset of the 
     CALS table model as described in the IETF HTML table specification, 
     see [RFC1942]. HTML 4.0 tables include the element types:

        caption, col, colgroup, table, tbody, td, tfoot, th, thead, tr 

     A conditional section includes additional declarations for the 
     Transitional DTD.  Note that in XML, multiple ATTLIST declarations 
     are merged.
-->

<!-- This module also supports the simple table model found in HTML 3.2
     by declaring the '%XHTML.Table40;' parameter entity to 'IGNORE'. 
     This removes the following elements from the HTML 4.0 table model:

         col, colgroup, tbody, tfoot, thead

     and also removes non-HTML 3.2 attributes and attribute values from
     the remaining element types.
--> 
<!ENTITY % XHTML.Table40  "INCLUDE" >
<![%XHTML.Table40;[

<!-- horizontal alignment attributes for cell contents -->
<!ENTITY % CellHAlign.attrib
     "align        (left|center|right|justify|char) #IMPLIED
      char         %Character;              #IMPLIED
      charoff      %Length;                 #IMPLIED"
>

<!-- vertical alignment attributes for cell contents -->
<!ENTITY % CellVAlign.attrib
     "valign       (top|middle|bottom|baseline) #IMPLIED" 
>

<!ENTITY % CaptionAlign  "(top|bottom|left|right)" >

<!-- Scope is simpler than axes attribute for common tables -->

<!ENTITY % Scope  "(row|col|rowgroup|colgroup)" >

<!ENTITY % Table.content
      "( caption?, ( col* | colgroup* ), (( thead?, tfoot?, tbody+ ) | ( tr+ )))" 
>
]]>
  
<!-- horizontal alignment attributes for cell contents -->
<!ENTITY % CellHAlign.attrib
     "align        (left|center|right)      #IMPLIED" 
>

<!-- vertical alignment attributes for cell contents -->
<!ENTITY % CellVAlign.attrib
     "valign       (top|middle|bottom)      #IMPLIED" 
>

<!ENTITY % CaptionAlign  "(top|bottom)">

<!-- The border attribute sets the thickness of the frame around the
     table. The default units are screen pixels.
-->

<!ENTITY % Table.content  "( caption?, tr+ )" >
<!ELEMENT table  %Table.content; >
<!ATTLIST table
      %Common.attrib;
      width        %Length;                 #IMPLIED
      border       %Pixels;                 #IMPLIED
      cellspacing  %Length;                 #IMPLIED
      cellpadding  %Length;                 #IMPLIED
>

<!ENTITY % Caption.content  "( #PCDATA | %Inline.mix; )*" >
<!ELEMENT caption  %Caption.content; >
<!ATTLIST caption
      %Common.attrib;
>

<!ENTITY % Tr.content  "( th | td )+" >
<!ELEMENT tr  %Tr.content; >
<!ATTLIST tr
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!-- th is for headers, td for data, but for cells acting as both use td -->

<!ENTITY % Th.content  "( #PCDATA | %Flow.mix; )*" >
<!ELEMENT th  %Th.content; >
<!ATTLIST th
      %Common.attrib;
      rowspan      %Number;                 '1'
      colspan      %Number;                 '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Td.content  "( #PCDATA | %Flow.mix; )*" >
<!ELEMENT td  %Td.content; >
<!ATTLIST td
      %Common.attrib;
      rowspan      %Number;                 '1'
      colspan      %Number;                 '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<![%XHTML.Table40;[
<!-- The frame attribute specifies which parts of the frame around
     the table should be rendered. The values are not the same as
     CALS to avoid a name clash with the valign attribute.

     The value "border" is included for backwards compatibility with
     <table border> which yields frame="border" and border="implied"
     For <table border="1"> you get border="1" and frame="implied".
     In this case, it is appropriate to treat this as frame="border" 
     for backwards compatibility with deployed browsers.
-->
<!ENTITY % TFrame  "(void|above|below|hsides|lhs|rhs|vsides|box|border)">

<!-- The rules attribute defines which rules to draw between cells.
     If rules is absent then assume:

       "none" if border is absent or border="0" otherwise "all"
-->
<!ENTITY % TRules  "(none|groups|rows|cols|all)">

<!ATTLIST table
      summary      %Text;                   #IMPLIED
      frame        %TFrame;                 #IMPLIED
      rules        %TRules;                 #IMPLIED
      datapagesize CDATA                    #IMPLIED
>

<!-- Use thead to duplicate headers when breaking table
     across page boundaries, or for static headers when
     TBODY sections are rendered in scrolling panel.

     Use tfoot to duplicate footers when breaking table
     across page boundaries, or for static footers when
     TBODY sections are rendered in scrolling panel.

     Use multiple tbody sections when rules are needed
     between groups of table rows.
-->
<!ENTITY % Thead.content  "( tr )+" >
<!ELEMENT thead  %Thead.content; >
<!ATTLIST thead
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Tfoot.content  "( tr )+" >
<!ELEMENT tfoot  %Tfoot.content; >
<!ATTLIST tfoot
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Tbody.content  "( tr )+" >
<!ELEMENT tbody  %Tbody.content; >
<!ATTLIST tbody
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Colgroup.content  "( col )*" >
<!ELEMENT colgroup  %Colgroup.content; >
<!-- colgroup groups a set of col elements. It allows you to group
     several semantically related columns together.
-->
<!ATTLIST colgroup
      %Common.attrib;
      span         %Number;                 '1'
      width        %MultiLength;            #IMPLIED
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Col.content  "EMPTY" >
<!ELEMENT col  %Col.content; >
<!-- col elements define the alignment properties for cells in
     one or more columns.

     The width attribute specifies the width of the columns, e.g.

       width="64"        width in screen pixels
       width="0.5*"      relative width of 0.5

     The span attribute causes the attributes of one
     col element to apply to more than one column.
-->
<!ATTLIST col
      %Common.attrib;
      span         %Number;                 '1'
      width        %MultiLength;            #IMPLIED
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ATTLIST th
      abbr         %Text;                   #IMPLIED
      axis         CDATA                    #IMPLIED
      headers      IDREFS                   #IMPLIED
      scope        %Scope;                  #IMPLIED
>

<!ATTLIST td
      abbr         %Text;                   #IMPLIED
      axis         CDATA                    #IMPLIED
      headers      IDREFS                   #IMPLIED
      scope        %Scope;                  #IMPLIED
>
]]>

<![%XHTML.Transitional;[
<!-- additional Transitional attributes for XHTML tables -->

<!-- horizontal placement of table relative to document -->
<!ENTITY % TAlign  "(left|center|right)" >

<!ATTLIST table
      align       %TAlign;                  #IMPLIED
      bgcolor     %Color;                   #IMPLIED
>

<!ATTLIST caption
      align       %CaptionAlign;            #IMPLIED
>

<!ATTLIST tr
      bgcolor     %Color;                   #IMPLIED
>

<!ATTLIST th
      nowrap      (nowrap)                  #IMPLIED
      bgcolor     %Color;                   #IMPLIED
      width       %Pixels;                  #IMPLIED
      height      %Pixels;                  #IMPLIED
>

<!ATTLIST td
      nowrap       (nowrap)                 #IMPLIED
      bgcolor      %Color;                  #IMPLIED
      width        %Pixels;                 #IMPLIED
      height       %Pixels;                 #IMPLIED
>
]]>

<!-- end of XHTML1-table.mod -->
