<!-- ...................................................................... -->
<!-- XHTML 1.0 Simple Table Module  ....................................... -->
<!-- file: XHTML1-table32.mod

     This module subsets XHTML 1.0, an XML reformulation of HTML 4.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)XHTML1-table32.mod 1.3 99/04/01 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.0-Based Subset Simplified Tables//EN"
     SYSTEM "XHTML1-table32.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Simplified (HTML 3.2) Tables 

     This table module is based on the HTML 3.2 table model, itself based 
     on a subset of the CALS table model as described in the IETF HTML
     table specification [see IETF RFC 1942]. While this module mimics the 
     content model and table attributes of HTML 3.2 tables, the element 
     types declared herein also includes all HTML 4.0 common attributes.

        table, caption, tr, th, td 
-->

<!-- horizontal alignment attributes for cell contents -->
<!ENTITY % CellHAlign.attrib
     "align        (left|center|right)      #IMPLIED" 
>

<!-- vertical alignment attributes for cell contents -->
<!ENTITY % CellVAlign.attrib
     "valign       (top|middle|bottom)      #IMPLIED" 
>

<!ENTITY % CaptionAlign  "(top|bottom)">

<!-- The border attribute sets the thickness of the frame around the
     table. The default units are screen pixels.
-->

<!ENTITY % Table.content  "( caption?, tr+ )" >
<!ELEMENT table  %Table.content; >
<!ATTLIST table
      %Common.attrib;
      width        %Length;                 #IMPLIED
      border       %Pixels;                 #IMPLIED
      cellspacing  %Length;                 #IMPLIED
      cellpadding  %Length;                 #IMPLIED
>

<!ENTITY % Caption.content  "( #PCDATA | %Inline.mix; )*" >
<!ELEMENT caption  %Caption.content; >
<!ATTLIST caption
      %Common.attrib;
>

<!ENTITY % Tr.content  "( th | td )+" >
<!ELEMENT tr  %Tr.content; >
<!ATTLIST tr
      %Common.attrib;
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!-- th is for headers, td for data, but for cells acting as both use td -->

<!ENTITY % Th.content  "( #PCDATA | %Flow.mix; )*" >
<!ELEMENT th  %Th.content; >
<!ATTLIST th
      %Common.attrib;
      rowspan      %Number;                 '1'
      colspan      %Number;                 '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<!ENTITY % Td.content  "( #PCDATA | %Flow.mix; )*" >
<!ELEMENT td  %Td.content; >
<!ATTLIST td
      %Common.attrib;
      rowspan      %Number;                 '1'
      colspan      %Number;                 '1'
      %CellHAlign.attrib;
      %CellVAlign.attrib;
>

<![%XHTML.Transitional;[
<!-- additional Transitional attributes for XHTML tables -->

<!-- horizontal placement of table relative to document -->
<!ENTITY % TAlign  "(left|center|right)" >

<!ATTLIST table
      align       %TAlign;                  #IMPLIED
      bgcolor     %Color;                   #IMPLIED
>

<!ATTLIST caption
      align       %CaptionAlign;            #IMPLIED
>

<!ATTLIST tr
      bgcolor     %Color;                   #IMPLIED
>

<!-- note that 'nowrap' in XML must be expressed as nowrap="nowrap" -->

<!ATTLIST th
      nowrap      (nowrap)                  #IMPLIED
      bgcolor     %Color;                   #IMPLIED
      width       %Pixels;                  #IMPLIED
      height      %Pixels;                  #IMPLIED
>

<!ATTLIST td
      nowrap       (nowrap)                 #IMPLIED
      bgcolor      %Color;                  #IMPLIED
      width        %Pixels;                 #IMPLIED
      height       %Pixels;                 #IMPLIED
>
]]>

<!-- end of XHTML1-table.mod -->
