<!-- ...................................................................... -->
<!-- XHTML 1.0 Structure Module  .......................................... -->
<!-- file: XHTML1-struct.mod

     This is XHTML 1.0, an XML reformulation of HTML 4.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)XHTML1-struct.mod 1.15 99/04/01 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.0 Document Structure//EN"
     SYSTEM "XHTML1-struct.mod"

     Revisions:
# 1998-10-27  content model on head changed to exclude multiple title or base
# 1998-11-11  ins and del inclusions on body removed, added to indiv. elements
# 1998-11-15  added head element version attribute (restoring from HTML 3.2)
# 1999-03-24  %Profile.attrib; unused, but reserved for future use
     ....................................................................... -->

<!-- a1. Document Structure 

        body, head, html
-->

<!ENTITY % Head-opts.mix  "( script | style | meta | link | object )*" > 

<!ENTITY % Head.content "( title, base?, %Head-opts.mix; )" > 

<!-- reserved for future use with document profiles -->
<!ENTITY % Profile.attrib 
     "profile      %URI;                    #FIXED '%XHTML.profile;'" >

<!ELEMENT head  %Head.content; > 
<!ATTLIST head 
      %I18n.attrib;
      profile      %URI;                    #IMPLIED
> 

<![%XHTML.Transitional;[
<!-- in Transitional, allow #PCDATA and inlines directly within body -->

<!ENTITY % Body.content  "( #PCDATA | %Flow.mix; )*" > 
]]>
<!ENTITY % Body.content
     "( %Heading.class; 
      | %List.class; 
      | %Block.class; 
      | %Misc.class; )+"
>

<!ELEMENT body  %Body.content; >
<!ATTLIST body
      %Common.attrib;
>

<![%XHTML.Transitional;[
<!-- ....  additional Transitional attributes on body .... -->

<!-- There are also 16 widely known color names with their sRGB values: 
 
    Black  = #000000   Maroon = #800000   Green  = #008000   Navy   = #000080 
    Silver = #C0C0C0   Red    = #FF0000   Lime   = #00FF00   Blue   = #0000FF 
    Gray   = #808080   Purple = #800080   Olive  = #808000   Teal   = #008080 
    White  = #FFFFFF   Fuchsia= #FF00FF   Yellow = #FFFF00   Aqua   = #00FFFF 
--> 

<!ATTLIST body
      bgcolor      %Color;                  #IMPLIED
      text         %Color;                  #IMPLIED
      link         %Color;                  #IMPLIED
      vlink        %Color;                  #IMPLIED
      alink        %Color;                  #IMPLIED
      background   %URI;                    #IMPLIED
>
]]>

<!ENTITY % Html.content  "( head, body )" >

<!-- version and namespace attribute values defined in driver -->
<!ENTITY % Version.attrib 
     "version      CDATA                    #FIXED '%HTML.version;'" >
<!ENTITY % Ns.attrib 
     "xmlns        %URI;                    #FIXED '%XHTML.ns;'" >

<!ELEMENT html  %Html.content; >
<!ATTLIST html
      %I18n.attrib;
      %Version.attrib;
      %Ns.attrib;
>

<!-- end of XHTML1-struct.mod -->
