<!-- ...................................................................... -->
<!-- XHTML 1.0 MathML Module  ............................................. -->
<!-- file: XHTML1-math.mod

     This is XHTML 1.0, an XML reformulation of HTML 4.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)XHTML1-math.mod 1.13 99/04/01 SMI

     This DTD module is identified within the XHTML 1.0 DTD
     by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.0 MathML//EN"
     SYSTEM "XHTML1-math.mod"

     Revisions:
# 1999-03-15    changed 'var' element to 'svar', 'select' to 'index'
     ....................................................................... -->

<!-- IMPORTANT: This module changes the element type names for two 
     elements in MathML to avoid conflict with existing HTML elements:

     var ('Statistical Variance') has been changed to svar
     select (an index into a vector, etc.) has been changed to index
-->
<!-- redeclare the inline special content model to include math -->

<!ENTITY % Inlspecial.class  "a | img | object | map | math" >

<!-- ............................................................... -->
<!--
  The MathML DTD                                 REC-MathML-19980407

  This module serves to provide the <math> top level mathematical
  element for embedding within an HTML document.
 
  ..............

  Parsing MathML
  
  MathML documents should be validated using the XML DTD below. Note
  in particular that the xml attribute xml:space is not used, so 
  whitespace characters in element content (ie. outside the presentation 
  token elements mi, mo, mn, mtext, mspace, mtext, ms , the content 
  token elements ci, cn and annotation) are not significant.
  
  If the MathML is parsed without a DTD (ie. as a well-formed XML 
  fragment), it is the responsibility of the processing application to 
  treat these whitespace characters as not significant.
  
  An SGML parser (such as nsgmls) can be used to validate MathML. In 
  this case an SGML declaration defining the constraints of XML 
  applicable to an SGML parser must be used. 

       See http://www.w3.org/TR/NOTE-sgml-xml 

-->
<!-- ............................................................... -->

<!-- ............................................................... -->
<!--
     Content model for content and presentation
     and browser interface tags in MathML

     initial draft 9.May.1997          syntax = XML
     author = s.buswell sb@stilo.demon.co.uk

     revised 14.May.1997 by Robert Miner
     revised 29.June.1997 and 2.July.1997 by s.buswell

     revised 15.December.1997  by s.buswell
     revised 8.February.1998   by s.buswell
     revised 4.april.1998      by s.buswell

     W3C Recommendation      7 April 1998
-->
<!-- ............................................................... -->

<!-- general attribute definitions for class & style & id & other    -->
<!-- : attributes shared by all mathml elements                      -->

<!ENTITY % att-globalatts 
   'class CDATA #IMPLIED
    style CDATA #IMPLIED
    id    ID    #IMPLIED
    other CDATA #IMPLIED'
  >

<!-- ............................................................... -->
<!-- Presentation element set                                        -->

<!-- presentation attribute definitions -->

<!ENTITY % att-fontsize     'fontsize CDATA #IMPLIED' >
<!ENTITY % att-fontweight   'fontweight (normal | bold) #IMPLIED' >
<!ENTITY % att-fontstyle    'fontstyle (normal | italic) #IMPLIED' >
<!ENTITY % att-fontfamily   'fontfamily CDATA   #IMPLIED' >
<!ENTITY % att-color        'color CDATA   #IMPLIED' >

<!ENTITY % att-fontinfo     
   '%att-fontsize;
    %att-fontweight;
    %att-fontstyle;
    %att-fontfamily;
    %att-color;' >

<!ENTITY % att-form         'form (prefix | infix | postfix) #IMPLIED' >
<!ENTITY % att-fence        'fence (true | false ) #IMPLIED' >
<!ENTITY % att-separator    'separator (true | false ) #IMPLIED' >
<!ENTITY % att-lspace       'lspace CDATA  #IMPLIED' >
<!ENTITY % att-rspace       'rspace CDATA  #IMPLIED' >
<!ENTITY % att-stretchy     'stretchy (true | false ) #IMPLIED' >
<!ENTITY % att-symmetric    'symmetric (true | false ) #IMPLIED' >
<!ENTITY % att-maxsize      'maxsize CDATA #IMPLIED' >
<!ENTITY % att-minsize      'minsize CDATA #IMPLIED' >
<!ENTITY % att-largeop      'largeop (true | false ) #IMPLIED' >
<!ENTITY % att-movablelimits  
   'movablelimits (true | false ) #IMPLIED' >
<!ENTITY % att-accent       'accent (true | false)  #IMPLIED'>

<!ENTITY % att-opinfo 
   '%att-form;
    %att-fence;
    %att-separator;
    %att-lspace;
    %att-rspace;
    %att-stretchy;
    %att-symmetric;
    %att-maxsize;
    %att-minsize;
    %att-largeop;
    %att-movablelimits;
    %att-accent;' >

<!ENTITY % att-width                'width CDATA #IMPLIED' >
<!ENTITY % att-height               'height CDATA #IMPLIED' >
<!ENTITY % att-depth                'depth CDATA #IMPLIED' >

<!ENTITY % att-sizeinfo     
   '%att-width;
    %att-height;
    %att-depth;' >

<!ENTITY % att-lquote               'lquote CDATA #IMPLIED' >
<!ENTITY % att-rquote               'rquote CDATA #IMPLIED' >

<!ENTITY % att-linethickness 'linethickness CDATA #IMPLIED' >

<!ENTITY % att-scriptlevel          'scriptlevel CDATA #IMPLIED'>
<!ENTITY % att-displaystyle         'displaystyle (true | false) #IMPLIED'>
<!ENTITY % att-scriptsizemultiplier 'scriptsizemultiplier CDATA #IMPLIED' >
<!ENTITY % att-scriptminsize        'scriptminsize CDATA #IMPLIED'>
<!ENTITY % att-background           'background CDATA #IMPLIED' >

<!ENTITY % att-open                 'open CDATA #IMPLIED' >
<!ENTITY % att-close                'close CDATA #IMPLIED' >
<!ENTITY % att-separators           'separators CDATA #IMPLIED' >

<!ENTITY % att-subscriptshift       'subscriptshift CDATA #IMPLIED'>
<!ENTITY % att-superscriptshift     'superscriptshift CDATA #IMPLIED' >

<!ENTITY % att-accentunder          'accentunder (true | false)
#IMPLIED'>

<!ENTITY % att-align                'align CDATA #IMPLIED' >
<!ENTITY % att-rowalign             'rowalign CDATA #IMPLIED' >
<!ENTITY % att-columnalign          'columnalign CDATA #IMPLIED' >
<!ENTITY % att-groupalign           'groupalign CDATA #IMPLIED' >
<!ENTITY % att-alignmentscope       'alignmentscope CDATA #IMPLIED' >

<!ENTITY % att-rowspacing           'rowspacing CDATA #IMPLIED' >
<!ENTITY % att-columnspacing        'columnspacing CDATA #IMPLIED' >
<!ENTITY % att-rowlines             'rowlines CDATA #IMPLIED' >
<!ENTITY % att-columnlines          'columnlines CDATA #IMPLIED' >
<!ENTITY % att-frame                'frame (none | solid | dashed)
#IMPLIED' >
<!ENTITY % att-framespacing         'framespacing CDATA #IMPLIED' >
<!ENTITY % att-equalrows            'equalrows CDATA #IMPLIED' >
<!ENTITY % att-equalcolumns         'equalcolumns CDATA #IMPLIED' >

<!ENTITY % att-tableinfo         
   '%att-align;
    %att-rowalign;
    %att-columnalign;
    %att-groupalign;
    %att-alignmentscope;
    %att-rowspacing;
    %att-columnspacing;
    %att-rowlines;
    %att-columnlines;
    %att-frame;
    %att-framespacing;
    %att-equalrows;
    %att-equalcolumns;
    %att-displaystyle;' >

<!ENTITY % att-rowspan        'rowspan CDATA #IMPLIED' >
<!ENTITY % att-columnspan     'columnspan CDATA #IMPLIED' >

<!ENTITY % att-edge           'edge (left | right)  #IMPLIED ' >

<!ENTITY % att-actiontype     'actiontype CDATA #IMPLIED' >
<!ENTITY % att-selection      'selection CDATA #IMPLIED ' >

<!-- presentation token schemata with content-->

<!ENTITY % ptoken "mi | mn | mo | mtext | ms" >

<!ATTLIST mi        %att-fontinfo;
                    %att-globalatts; >

<!ATTLIST mn        %att-fontinfo;
                    %att-globalatts; >

<!ATTLIST mo        %att-fontinfo;
                    %att-opinfo;
                    %att-globalatts; >

<!ATTLIST mtext     %att-fontinfo;
                    %att-globalatts; >

<!ATTLIST ms        %att-fontinfo;
                    %att-lquote;
                    %att-rquote;
                    %att-globalatts; >

<!-- empty presentation token schemata -->

<!ENTITY % petoken  "mspace" >
<!ELEMENT mspace     EMPTY >

<!ATTLIST mspace    %att-sizeinfo;
                    %att-globalatts; >

<!-- presentation general layout schemata -->

<!ENTITY % pgenschema 
    "mrow|mfrac|msqrt|mroot|mstyle|merror|mpadded| mphantom|mfenced" >

<!ATTLIST mrow      %att-globalatts; >

<!ATTLIST mfrac     %att-linethickness;
                    %att-globalatts; >

<!ATTLIST msqrt     %att-globalatts; >

<!ATTLIST mroot     %att-globalatts; >

<!ATTLIST mstyle    %att-fontinfo;
                    %att-opinfo;
                    %att-lquote;
                    %att-rquote;
                    %att-linethickness;
                    %att-scriptlevel;
                    %att-displaystyle;
                    %att-scriptsizemultiplier;
                    %att-scriptminsize;
                    %att-background;
                    %att-open;
                    %att-close;
                    %att-separators;
                    %att-subscriptshift;
                    %att-superscriptshift;
                    %att-accentunder;
                    %att-tableinfo;
                    %att-rowspan;
                    %att-columnspan;
                    %att-edge;
                    %att-actiontype;
                    %att-selection;
                    %att-globalatts; >

<!ATTLIST merror    %att-globalatts; >

<!ATTLIST mpadded   %att-sizeinfo;
                    %att-lspace;
                    %att-globalatts; >

<!ATTLIST mphantom  %att-globalatts; >

<!ATTLIST mfenced   %att-open;
                    %att-close;
                    %att-separators;
                    %att-globalatts; >

<!-- presentation  layout schemata : scripts and limits -->

<!ENTITY % pscrschema  
   "msub|msup|msubsup| munder|mover|munderover|mmultiscripts" >

<!ATTLIST msub      %att-subscriptshift;
                    %att-globalatts; >

<!ATTLIST msup      %att-superscriptshift;
                    %att-globalatts; >

<!ATTLIST msubsup   %att-subscriptshift;
                    %att-superscriptshift;
                    %att-globalatts; >

<!ATTLIST munder    %att-accentunder;
                    %att-globalatts; >

<!ATTLIST mover     %att-accent;
                    %att-globalatts; >

<!ATTLIST munderover %att-accent;
                     %att-accentunder;
                     %att-globalatts; >

<!ATTLIST mmultiscripts
                    %att-subscriptshift;
                    %att-superscriptshift;
                    %att-globalatts; >

<!-- presentation layout schemata: script empty elements -->

<!ENTITY % pscreschema "mprescripts|none" >

<!ELEMENT mprescripts   EMPTY >
<!ATTLIST mprescripts         %att-globalatts; >

<!ELEMENT none          EMPTY >
<!ATTLIST none      %att-globalatts; >

<!-- presentation layout schemata: tables -->

<!ENTITY % ptabschema "mtable|mtr|mtd" >

<!ATTLIST mtable    %att-tableinfo;
                    %att-globalatts; >

<!ATTLIST mtr       %att-rowalign;
                    %att-columnalign;
                    %att-groupalign;
                    %att-globalatts; >

<!ATTLIST mtd       %att-rowalign;
                    %att-columnalign;
                    %att-groupalign;
                    %att-rowspan;
                    %att-columnspan;
                    %att-globalatts; >

<!ENTITY % plschema  "%pgenschema;|%pscrschema;|%ptabschema;" >

<!-- empty presentation layout schemata -->

<!ENTITY % peschema "maligngroup | malignmark" >

<!ELEMENT  malignmark  EMPTY >

<!ATTLIST malignmark     %att-edge;
                         %att-globalatts; >

<!ELEMENT maligngroup    EMPTY >
<!ATTLIST maligngroup    %att-groupalign;
                         %att-globalatts; >

<!-- presentation action schemata -->

<!ENTITY % pactions "maction" >
<!ATTLIST maction   %att-actiontype;
                    %att-selection;
                    %att-globalatts; >

<!-- Presentation entity for substitution into content tag constructs -->
<!-- excludes elements which are not valid as expressions             -->

<!ENTITY % PresInCont 
   "%ptoken; | 
    %petoken; | 
    %plschema; | 
    %peschema; | 
    %pactions; " >

<!-- Presentation entity - all presentation constructs -->

<!ENTITY % Presentation  
   "%ptoken; | 
    %petoken; | 
    %pscreschema; |
    %plschema; | 
    %peschema; | 
    %pactions; " >

<!-- ............................................................... -->
<!-- Content element set                                             -->
<!-- attribute definitions                                           -->

<!ENTITY % att-base              'base CDATA "10"' >
<!ENTITY % att-closure           'closure CDATA "closed"' >
<!ENTITY % att-definition        'definitionURL CDATA ""' >
<!ENTITY % att-encoding          'encoding CDATA ""' >
<!ENTITY % att-nargs             'nargs CDATA "1"' >
<!ENTITY % att-occurence         'occurence CDATA "function-model"' >
<!ENTITY % att-order             'order CDATA "numeric"' >
<!ENTITY % att-scope             'scope CDATA "local"' >
<!ENTITY % att-type              'type CDATA #IMPLIED' >

<!-- content leaf token elements -->

<!ENTITY % ctoken "ci | cn" >

<!ATTLIST ci        %att-type;
                    %att-globalatts; >

<!ATTLIST cn        %att-type;
                    %att-base;
                    %att-globalatts; >

<!-- content elements - specials -->

<!ENTITY % cspecial "apply | reln | lambda" >

<!ATTLIST apply     %att-globalatts; >

<!ATTLIST reln      %att-globalatts; >

<!ATTLIST lambda    %att-globalatts; >

<!-- content elements - others -->

<!ENTITY % cother "condition | declare | sep" >

<!ATTLIST condition %att-globalatts; 
  >

<!ATTLIST declare   %att-type;
                    %att-scope;
                    %att-nargs;
                    %att-occurence;
                    %att-definition;
                    %att-globalatts; >

<!ELEMENT sep  EMPTY >
<!ATTLIST sep       %att-globalatts; >

<!-- content elements - semantic mapping -->

<!ENTITY % csemantics "semantics | annotation | annotation-xml" >

<!ATTLIST semantics           %att-definition;
                              %att-globalatts; >

<!ATTLIST annotation          %att-encoding;
                              %att-globalatts; >

<!ATTLIST annotation-xml      %att-encoding;
                              %att-globalatts; >

<!-- content elements - constructors -->

<!ENTITY % cconstructor 
   "interval | list | matrix | matrixrow | set | vector" >

<!ATTLIST interval     %att-closure;
                       %att-globalatts; >

<!ATTLIST set          %att-globalatts; >

<!ATTLIST list         %att-order;
                       %att-globalatts; >

<!ATTLIST vector       %att-globalatts; >

<!ATTLIST matrix       %att-globalatts; >

<!ATTLIST matrixrow    %att-globalatts; >

<!-- content elements - operators -->

<!ENTITY % cfuncop1ary "inverse | ident " >

<!ELEMENT inverse          EMPTY >
<!ATTLIST inverse      %att-definition;
                       %att-globalatts; >

<!ENTITY % cfuncopnary "fn |  compose" >

<!ATTLIST fn           %att-definition;
                       %att-globalatts; >

<!ELEMENT ident        EMPTY >
<!ATTLIST ident        %att-definition;
                       %att-globalatts; >

<!ELEMENT compose      EMPTY >
<!ATTLIST compose      %att-definition;
                       %att-globalatts; >

<!ENTITY % carithop1ary "abs | conjugate | exp | factorial" >

<!ELEMENT exp          EMPTY >
<!ATTLIST exp          %att-definition;
                       %att-globalatts; >

<!ELEMENT abs          EMPTY >
<!ATTLIST abs          %att-definition;
                       %att-globalatts; >

<!ELEMENT conjugate    EMPTY >
<!ATTLIST conjugate    %att-definition;
                       %att-globalatts; >

<!ELEMENT factorial    EMPTY >
<!ATTLIST factorial    %att-definition;
                       %att-globalatts; >

<!ENTITY % carithop1or2ary "minus" >

<!ELEMENT minus        EMPTY >
<!ATTLIST minus        %att-definition;
                       %att-globalatts; >

<!ENTITY % carithop2ary "quotient | divide | power | rem" >

<!ELEMENT quotient     EMPTY >
<!ATTLIST quotient     %att-definition;
                       %att-globalatts; >

<!ELEMENT divide       EMPTY >
<!ATTLIST divide       %att-definition;
                       %att-globalatts; >

<!ELEMENT power        EMPTY >
<!ATTLIST power        %att-definition;
                       %att-globalatts; >

<!ELEMENT rem          EMPTY >
<!ATTLIST rem          %att-definition;
                       %att-globalatts; >

<!ENTITY % carithopnary "plus | times | max | min | gcd" >

<!ELEMENT plus         EMPTY >
<!ATTLIST plus         %att-definition;
                       %att-globalatts; >

<!ELEMENT max          EMPTY >
<!ATTLIST max          %att-definition;
                       %att-globalatts; >

<!ELEMENT min          EMPTY >
<!ATTLIST min          %att-definition;
                       %att-globalatts; >

<!ELEMENT times        EMPTY >
<!ATTLIST times        %att-definition;
                       %att-globalatts; >

<!ELEMENT gcd          EMPTY >
<!ATTLIST gcd          %att-definition;
                       %att-globalatts; >

<!ENTITY % carithoproot "root" >

<!ELEMENT root         EMPTY >
<!ATTLIST root         %att-definition;
                       %att-globalatts; >

<!ENTITY % clogicopquant "exists | forall" >

<!ELEMENT exists       EMPTY >
<!ATTLIST exists       %att-definition;
                       %att-globalatts; >

<!ELEMENT forall       EMPTY >
<!ATTLIST forall       %att-definition;
                       %att-globalatts; >

<!ENTITY % clogicopnary "and | or | xor" >

<!ELEMENT and          EMPTY >
<!ATTLIST and          %att-definition;
                       %att-globalatts; >

<!ELEMENT or           EMPTY >
<!ATTLIST or           %att-definition;
                       %att-globalatts; >

<!ELEMENT xor          EMPTY >
<!ATTLIST xor          %att-definition;
                       %att-globalatts; >

<!ENTITY % clogicop1ary "not" >

<!ELEMENT not          EMPTY >
<!ATTLIST not          %att-definition;
                       %att-globalatts; >

<!ENTITY % clogicop2ary "implies" >

<!ELEMENT implies      EMPTY >
<!ATTLIST implies      %att-definition;
                       %att-globalatts; >

<!ENTITY % ccalcop "log | int | diff | partialdiff" >

<!ELEMENT log          EMPTY >
<!ATTLIST log          %att-definition;
                       %att-globalatts; >

<!ELEMENT int          EMPTY >
<!ATTLIST int          %att-definition;
                       %att-globalatts; >

<!ELEMENT diff         EMPTY >
<!ATTLIST diff         %att-definition;
                       %att-globalatts; >

<!ELEMENT partialdiff  EMPTY >
<!ATTLIST partialdiff  %att-definition;
                       %att-globalatts; >

<!ENTITY % ccalcop1ary "ln" >

<!ELEMENT ln           EMPTY >
<!ATTLIST ln           %att-definition;
                       %att-globalatts; >

<!ENTITY % csetop2ary "setdiff" >

<!ELEMENT setdiff      EMPTY >
<!ATTLIST setdiff      %att-definition;
                       %att-globalatts; >

<!ENTITY % csetopnary "union | intersect" >

<!ELEMENT union        EMPTY >
<!ATTLIST union        %att-definition;
                       %att-globalatts; >

<!ELEMENT intersect    EMPTY >
<!ATTLIST intersect    %att-definition;
                       %att-globalatts; >

<!ENTITY % cseqop "sum | product | limit" >

<!ELEMENT sum          EMPTY >
<!ATTLIST sum          %att-definition;
                       %att-globalatts; >

<!ELEMENT product      EMPTY >
<!ATTLIST product      %att-definition;
                       %att-globalatts; >

<!ELEMENT limit        EMPTY >
<!ATTLIST limit        %att-definition;
                       %att-globalatts; >

<!ENTITY % ctrigop "sin | cos | tan | sec | csc | cot | sinh
                | cosh | tanh | sech | csch | coth
                | arcsin | arccos | arctan" >

<!ELEMENT sin          EMPTY >
<!ATTLIST sin          %att-definition;
                       %att-globalatts; >

<!ELEMENT cos          EMPTY >
<!ATTLIST cos          %att-definition;
                       %att-globalatts; >

<!ELEMENT tan          EMPTY >
<!ATTLIST tan          %att-definition;
                       %att-globalatts; >

<!ELEMENT sec          EMPTY >
<!ATTLIST sec          %att-definition;
                       %att-globalatts; >

<!ELEMENT csc          EMPTY >
<!ATTLIST csc          %att-definition;
                       %att-globalatts; >

<!ELEMENT cot          EMPTY >
<!ATTLIST cot          %att-definition;
                       %att-globalatts; >

<!ELEMENT sinh         EMPTY >
<!ATTLIST sinh         %att-definition;
                       %att-globalatts; >

<!ELEMENT cosh         EMPTY >
<!ATTLIST cosh         %att-definition;
                       %att-globalatts; >

<!ELEMENT tanh         EMPTY >
<!ATTLIST tanh         %att-definition;
                       %att-globalatts; >

<!ELEMENT sech         EMPTY >
<!ATTLIST sech         %att-definition;
                       %att-globalatts; >

<!ELEMENT csch         EMPTY >
<!ATTLIST csch         %att-definition;
                       %att-globalatts; >

<!ELEMENT coth         EMPTY >
<!ATTLIST coth         %att-definition;
                       %att-globalatts; >

<!ELEMENT arcsin       EMPTY >
<!ATTLIST arcsin       %att-definition;
                       %att-globalatts; >

<!ELEMENT arccos       EMPTY >
<!ATTLIST arccos       %att-definition;
                       %att-globalatts; >

<!ELEMENT arctan       EMPTY >
<!ATTLIST arctan       %att-definition;
                       %att-globalatts; >

<!ENTITY % cstatopnary "mean | sdev | svar | median | mode" >

<!ELEMENT mean         EMPTY >
<!ATTLIST mean         %att-definition;
                       %att-globalatts; >

<!ELEMENT sdev         EMPTY >
<!ATTLIST sdev         %att-definition;
                       %att-globalatts; >

<!ELEMENT svar         EMPTY >
<!ATTLIST svar         %att-definition;
                       %att-globalatts; >

<!ELEMENT median       EMPTY >
<!ATTLIST median       %att-definition;
                       %att-globalatts; >

<!ELEMENT mode         EMPTY >
<!ATTLIST mode         %att-definition;
                       %att-globalatts; >

<!ENTITY % cstatopmoment "moment" >

<!ELEMENT moment       EMPTY >
<!ATTLIST moment       %att-definition;
                       %att-globalatts; >

<!ENTITY % clalgop1ary "determinant | transpose" >

<!ELEMENT determinant  EMPTY >
<!ATTLIST determinant  %att-definition;
                       %att-globalatts; >

<!ELEMENT transpose    EMPTY >
<!ATTLIST transpose    %att-definition;
                       %att-globalatts; >

<!ENTITY % clalgopnary "index" >

<!ELEMENT index        EMPTY >
<!ATTLIST index        %att-definition;
                       %att-globalatts; >

<!-- content elements -  relations  -->

<!ENTITY % cgenrel2ary "neq" >

<!ELEMENT neq          EMPTY >
<!ATTLIST neq          %att-definition;
                       %att-globalatts; >

<!ENTITY % cgenrelnary "eq | leq | lt | geq | gt" >

<!ELEMENT eq           EMPTY >
<!ATTLIST eq           %att-definition;
                       %att-globalatts; >

<!ELEMENT gt           EMPTY >
<!ATTLIST gt           %att-definition;
                       %att-globalatts; >

<!ELEMENT lt           EMPTY >
<!ATTLIST lt           %att-definition;
                       %att-globalatts; >

<!ELEMENT geq          EMPTY >
<!ATTLIST geq          %att-definition;
                       %att-globalatts; >

<!ELEMENT leq          EMPTY >
<!ATTLIST leq          %att-definition;
                       %att-globalatts; >

<!ENTITY % csetrel2ary "in | notin | notsubset | notprsubset" >

<!ELEMENT in           EMPTY >
<!ATTLIST in           %att-definition;
                       %att-globalatts; >

<!ELEMENT notin        EMPTY >
<!ATTLIST notin        %att-definition;
                       %att-globalatts; >

<!ELEMENT notsubset    EMPTY >
<!ATTLIST notsubset    %att-definition;
                       %att-globalatts; >

<!ELEMENT notprsubset  EMPTY >
<!ATTLIST notprsubset  %att-definition;
                       %att-globalatts; >

<!ENTITY % csetrelnary "subset | prsubset" >

<!ELEMENT subset       EMPTY >
<!ATTLIST subset       %att-definition;
                       %att-globalatts; >

<!ELEMENT prsubset     EMPTY >
<!ATTLIST prsubset     %att-definition;
                       %att-globalatts; >

<!ENTITY % cseqrel2ary "tendsto" >

<!ELEMENT tendsto      EMPTY >
<!ATTLIST tendsto      %att-definition;
                       %att-type;
                       %att-globalatts; >

<!-- content elements -  quantifiers  -->

<!ENTITY % cquantifier "lowlimit | uplimit | bvar | degree | logbase" >

<!ATTLIST lowlimit     %att-globalatts; >

<!ATTLIST uplimit      %att-globalatts; >

<!ATTLIST bvar         %att-globalatts; >

<!ATTLIST degree       %att-globalatts; >

<!ATTLIST logbase      %att-globalatts; >

<!-- operator groups -->

<!ENTITY % cop1ary 
   "%cfuncop1ary;| 
    %carithop1ary; | 
    %clogicop1ary; | 
    %ccalcop1ary; | 
    %ctrigop; | 
    %clalgop1ary; " >

<!ENTITY % cop2ary 
   "%carithop2ary; | 
    %clogicop2ary;| 
    %csetop2ary; " >

<!ENTITY % copnary 
   "%cfuncopnary; | 
    %carithopnary; | 
    %clogicopnary; | 
    %csetopnary; | 
    %cstatopnary; | 
    %clalgopnary; " >

<!ENTITY % copmisc 
   "%carithoproot; | 
    %carithop1or2ary; | 
    %ccalcop; | 
    %cseqop; | 
    %cstatopmoment; | 
    %clogicopquant; " >

<!-- relation groups -->

<!ENTITY % crel2ary 
   "%cgenrel2ary; | 
    %csetrel2ary; | 
    %cseqrel2ary; " >

<!ENTITY % crelnary 
   "%cgenrelnary; | 
    %csetrelnary;" >

<!-- content constructs - all -->

<!ENTITY % Content 
   "%ctoken; | 
    %cspecial; | 
    %cother; | 
    %csemantics; |
    %cconstructor; | 
    %cquantifier; |
    %cop1ary; |
    %cop2ary; |
    %copnary; |
    %copmisc; |
    %crel2ary; |
    %crelnary;" > 

<!-- content constructs for substitution in presentation structures -->

<!ENTITY % ContInPres 
   "ci | cn  | apply  | fn | lambda | reln | 
    interval | list | matrix |matrixrow | set | vector" >

<!-- ............................................................... -->

<!-- recursive definition for content of expressions             -->
<!-- include presentation tag constructs at lowest level         -->
<!-- so presentation layout schemata hold presentation or Content -->
<!-- include Content tag constructs at lowest level              -->
<!-- so Content tokens hold PCDATA or Presentation at leaf level -->
<!-- (for permitted substitutable elements in context)           -->

<!ENTITY % ContentExpression   "(%Content; | %PresInCont;)* " >
<!ENTITY % PresExpression      "(%Presentation; | %ContInPres;)* " >
<!ENTITY % MathExpression      "(%PresInCont; | %ContInPres;)* " >

<!--  content token elements (may hold embedded presentation constructs)
-->

<!ELEMENT ci             (#PCDATA | %PresInCont;)* >
<!ELEMENT cn             (#PCDATA | sep | %PresInCont;)* >

<!--  content special elements    -->

<!ELEMENT apply          (%ContentExpression;) >
<!ELEMENT reln           (%ContentExpression;) >
<!ELEMENT lambda         (%ContentExpression;) >

<!--  content other elements    -->

<!ELEMENT condition      (%ContentExpression;) >
<!ELEMENT declare        (%ContentExpression;) >

<!--  content semantics elements    -->

<!ELEMENT semantics      (%ContentExpression;) >
<!ELEMENT annotation     (#PCDATA) >
<!ELEMENT annotation-xml (%ContentExpression;) >

<!--  content constructor elements    -->

<!ELEMENT interval       (%ContentExpression;) >
<!ELEMENT set            (%ContentExpression;) >
<!ELEMENT list           (%ContentExpression;) >
<!ELEMENT vector         (%ContentExpression;) >
<!ELEMENT matrix         (%ContentExpression;) >
<!ELEMENT matrixrow      (%ContentExpression;) >

<!--  content operator element (user-defined)    -->

<!ELEMENT fn       (%ContentExpression;) >

<!--  content quantifier elements    -->

<!ELEMENT lowlimit       (%ContentExpression;) >
<!ELEMENT uplimit        (%ContentExpression;) >
<!ELEMENT bvar           (%ContentExpression;) >
<!ELEMENT degree         (%ContentExpression;) >
<!ELEMENT logbase        (%ContentExpression;) >

<!-- ............................................................... -->
<!-- presentation layout schema contain tokens, layout and 
     content schema  -->

<!ELEMENT mstyle          (%PresExpression;) >
<!ELEMENT merror          (%PresExpression;) >
<!ELEMENT mphantom        (%PresExpression;) >
<!ELEMENT mrow            (%PresExpression;) >
<!ELEMENT mfrac           (%PresExpression;) >
<!ELEMENT msqrt           (%PresExpression;) >
<!ELEMENT mroot           (%PresExpression;) >
<!ELEMENT msub            (%PresExpression;) >
<!ELEMENT msup            (%PresExpression;) >
<!ELEMENT msubsup         (%PresExpression;) >
<!ELEMENT mmultiscripts   (%PresExpression;) >
<!ELEMENT munder          (%PresExpression;) >
<!ELEMENT mover           (%PresExpression;) >
<!ELEMENT munderover      (%PresExpression;) >
<!ELEMENT mtable          (%PresExpression;) >
<!ELEMENT mtr             (%PresExpression;) >
<!ELEMENT mtd             (%PresExpression;) >
<!ELEMENT maction         (%PresExpression;) >
<!ELEMENT mfenced         (%PresExpression;) >
<!ELEMENT mpadded         (%PresExpression;) >

<!-- presentation tokens contain PCDATA or malignmark constructs -->

<!ELEMENT mi     (#PCDATA | malignmark )* >
<!ELEMENT mn     (#PCDATA | malignmark )* >
<!ELEMENT mo     (#PCDATA | malignmark )* >
<!ELEMENT mtext  (#PCDATA | malignmark )* >
<!ELEMENT ms     (#PCDATA | malignmark )* >

<!-- ............................................................... -->
<!-- browser interface definition -->

<!-- attributes for top level math element -->

<!ENTITY  %     att-macros      'macros CDATA #IMPLIED' >
<!ENTITY  %     att-mode        'mode   CDATA #IMPLIED' >

<!ENTITY  %     att-topinfo    
   '%att-globalatts;
    %att-macros;
    %att-mode; ' >

<!-- attributes for browser interface element element -->

<!ENTITY  %     att-name        'name CDATA #IMPLIED' >
<!ENTITY  %     att-height      'height CDATA #IMPLIED' >
<!ENTITY  %     att-width       'width CDATA #IMPLIED' >
<!ENTITY  %     att-baseline    'baseline CDATA #IMPLIED' >
<!ENTITY  %     att-overflow    
   'overflow (scroll|elide|truncate|scale) "scroll"' >
<!ENTITY  %     att-altimg      'altimg CDATA #IMPLIED' >
<!ENTITY  %     att-alttext     'alttext CDATA #IMPLIED' >

<!ENTITY  %     att-browif      
   '%att-type;
    %att-name;
    %att-height;
    %att-width;
    %att-baseline;
    %att-overflow;
    %att-altimg;
    %att-alttext; ' >

<!-- the top level math element                         -->
<!-- math contains MathML encoded mathematics           -->
<!-- math has the browser info attributes iff it is the
     browser interface element also                
-->

<!ELEMENT  math     (%MathExpression;) >

<!ATTLIST  math     %att-topinfo;
                    %att-browif; >

<!-- end of XHTML1-math.mod DTD fragment -->
