/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.namespaces;

import org.w3c.dom.*;

/**
 * The <code>Node</code> interface is extended to include a set of attributes 
 * to access the namespace prefix and namespace name of a node, and the local 
 * part of its qualified name (also called "local name" in this document).
 * This is the same as in Option #1 with the additional 
 * <code>universalName</code> attribute.
 */
public interface NodeNS {
  /**
   * Returns the universal name of this node.
   */
  public String             getUniversalName();
  /**
   * Returns the namespace name of this node or <code>null</code> if it is 
   * unspecified.
   * <br>This is not a computed value that is the result of a namespace lookup 
   * based on an examination of the namespace declarations in scope. It is 
   * merely the namespace name given at creation time.
   */
  public String             getNamespaceName();
  /**
   * The namespace prefix of this node or <code>null</code> if it is 
   * unspecified.
   * <br>Note that setting this attribute changes the <code>nodeName</code> 
   * attribute, which holds the qualified name, as well as the 
   * <code>Element.tagName</code> and <code>Attr.name</code> attributes when 
   * applicable.
   * @exception DOMException
   *   INVALID_CHARACTER_ERR: Raised if the specified prefix contains an 
   *   invalid character.
   */
  public String             getPrefix();
  public void               setPrefix(String prefix)
                                                   throws DOMException;
  /**
   * Returns the local part of the qualified name of this node.
   */
  public String             getLocalName();
}

