/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.namespaces;

import org.w3c.dom.*;

/**
 * The <code>Document</code> interface provides two new methods for creating 
 * XML elements and attributes with a namespace prefix and namespace name.
 */
public interface DocumentNS {
  /**
   * Creates an element of the given qualified name and namespace name.
   * @param namespaceName The namespace name of the element to create.
   * @param qualifiedName The qualified name of the element type to 
   *   instantiate. This can contain a namespace prefix.
   * @return A new <code>Element</code> object with the following attributes:
   *   AttributeValue<code>Node.nodeName</code>qualifiedName
   *   <code>Node.namespaceName</code>namespaceName<code>Node.prefix</code>
   *   prefix, extracted from qualifiedName, or null if there is no prefix
   *   <code>Node.localName</code>local part, extracted from qualifiedName
   *   <code>Element.tagName</code>qualifiedName
   * @exception DOMException
   *   INVALID_CHARACTER_ERR: Raised if the specified name contains an 
   *   invalid character.
   */
  public Element            createElementNS(String namespaceName, 
                                            String qualifiedName)
                                            throws DOMException;
  /**
   * Creates an attribute of the given qualified name and namespace name.
   * @param namespaceName The namespace name of the attribute to create.
   * @param qualifiedName The qualified name of the attribute to instantiate. 
   *   This can contain a namespace prefix.
   * @return A new <code>Attr</code> object with the following attributes:
   *   AttributeValue<code>Node.nodeName</code>qualifiedName
   *   <code>Node.namespaceName</code>namespaceName<code>Node.prefix</code>
   *   prefix, extracted from qualifiedName, or null if there is no prefix
   *   <code>Node.localName</code>local part, extracted from qualifiedName
   *   <code>Attr.name</code>qualifiedName
   * @exception DOMException
   *   INVALID_CHARACTER_ERR: Raised if the specified name contains an 
   *   invalid character.
   */
  public Attr               createAttributeNS(String namespaceName, 
                                              String qualifiedName)
                                              throws DOMException;
  /**
   * Returns a <code>NodeList</code> of all the <code>Element</code>s with a 
   * given local name and namespace name in the order in which they would be 
   * encountered in a preorder traversal of the <code>Document</code> tree.
   * @param namespaceName The namespace name of the elements to match on. The 
   *   special value "*" matches all namespaces.
   * @param localName The local name of the elements to match on. The special 
   *   value "*" matches all local names.
   * @return A new <code>NodeList</code> object containing all the matched 
   *   <code>Element</code>s.
   */
  public NodeList           getElementsByTagNameNS(String namespaceName, 
                                                   String localName);
}

