/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.fi;

import org.w3c.dom.*;

/**
 * TreeWalkers are used to navigate a document tree or subtree using the view
 * of the document defined by its whatToShow flags and any filters that are
 * defined for the TreeWalker. Any function which performs navigation using a
 * TreeWalker will automatically support any view defined by a TreeWalker.
 */
public interface TreeWalker {
  /**
   * This attribute determines whether entities are expanded, and whether
   * comments, processing instructions, or text are presented via the 
   * iterator. 
   */
  public int                getWhatToShow();
  // Constants for whatToShow
  public static final int             SHOW_ALL             = 0xFFFF;
  public static final int             SHOW_ELEMENT         = 0x00000001;
  public static final int             SHOW_ATTRIBUTE       = 0x00000002;
  public static final int             SHOW_TEXT            = 0x00000004;
  public static final int             SHOW_CDATA_SECTION   = 0x00000008;
  public static final int             SHOW_ENTITY_REFERENCE = 0x00000010;
  public static final int             SHOW_ENTITY          = 0x00000020;
  public static final int             SHOW_PROCESSING_INSTRUCTION = 0x00000040;
  public static final int             SHOW_COMMENT         = 0x00000080;
  public static final int             SHOW_DOCUMENT        = 0x00000100;
  public static final int             SHOW_DOCUMENT_TYPE   = 0x00000200;
  public static final int             SHOW_DOCUMENT_FRAGMENT = 0x00000400;
  public static final int             SHOW_NOTATION        = 0x00000800;

  /**
   * The filter used to screen nodes.
   */
  public NodeFilter         getFilter();
  /**
   * Returns the current node without changing position. 
   * @return The current node.
   */
  public Node               current();
  /**
   * Moves to the parent node. This method will never position beyond the root 
   * ofthe subtree for which the TreeWalker was created. 
   * @return The new node. If the current node is the root of the subtree for 
   *   which theTreeWalker was created, returns null, and retains the current 
   *   node.
   */
  public Node               parentNode();
  /**
   * Moves the TreeWalker to the first child of the current node, and returns 
   * thenew node. If the current node has no children, returns null, and 
   * retains thecurrent node. 
   * @return The new node, or null if the current node has no children.
   */
  public Node               firstChild();
  /**
   * Moves the TreeWalker to the last child of the current node, and returns 
   * thenew node. If the current node has no children, returns null, and 
   * retains thecurrent node. 
   * @return The new node, or null if the current node has no children.
   */
  public Node               lastChild();
  /**
   * Moves the TreeWalker to the previous sibling of the current node, and
   * returns the new node. If the current node has no previous sibling, 
   * returnsnull, and retains the current node. 
   * @return The new node, or null if the current node has no previous sibling.
   */
  public Node               previousSibling();
  /**
   * Moves the TreeWalker to the next sibling of the current node, and returns
   * the new node. If the current node has no next sibling, returns null, and
   * retains the current node. 
   * @return The new node, or null if the current node has no next sibling.
   */
  public Node               nextSibling();
}

