/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.fi;

import org.w3c.dom.*;

/**
 * NodeIterators are used to step through a set of nodes, e.g. the set of nodes
 * in a NodeList, the document subtree governed by a particular node, the 
 * resultsof a query, or any other set of nodes. The set of nodes to be 
 * iterated isdetermined by the factory that creates the iterator.
 * <p>Any iterator that returns nodes may implement the NodeIterator interface.
 * Users and vendor libraries may also choose to create iterators that 
 * implementthe NodeIterator interface.
 */
public interface NodeIterator {
  /**
   * This attribute determines whether entities are expanded, and whether
   * comments, processing instructions, or text are presented via the 
   * iterator. 
   */
  public int                getWhatToShow();
  // Constants for whatToShow
  public static final int             SHOW_ALL             = 0xFFFF;
  public static final int             SHOW_ELEMENT         = 0x00000001;
  public static final int             SHOW_ATTRIBUTE       = 0x00000002;
  public static final int             SHOW_TEXT            = 0x00000004;
  public static final int             SHOW_CDATA_SECTION   = 0x00000008;
  public static final int             SHOW_ENTITY_REFERENCE = 0x00000010;
  public static final int             SHOW_ENTITY          = 0x00000020;
  public static final int             SHOW_PROCESSING_INSTRUCTION = 0x00000040;
  public static final int             SHOW_COMMENT         = 0x00000080;
  public static final int             SHOW_DOCUMENT        = 0x00000100;
  public static final int             SHOW_DOCUMENT_TYPE   = 0x00000200;
  public static final int             SHOW_DOCUMENT_FRAGMENT = 0x00000400;
  public static final int             SHOW_NOTATION        = 0x00000800;

  /**
   * The filter used to screen nodes.
   */
  public NodeFilter         getFilter();
  /**
   * Returns the next node in the set and advances the position of the iterator
   * in the set. After a NodeIterator is created, the first call to nextNode()
   * returns the first node in the set. 
   * @return The next  <code>Node</code>in the set being iterated over, or 
   *   NULL if there are no more members in thatset. 
   */
  public Node               nextNode();
  /**
   * Returns the previous node in the set and moves the position of the 
   * iteratorbackwards in the set. 
   * @return The previous  <code>Node</code>in the set being iterated over, or 
   *   NULL if there are no more members in thatset. 
   */
  public Node               previousNode();
}

