/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.fi;

import org.w3c.dom.*;

/**
 * Filters are simply objects that know how to "filter out" nodes. If an
 * iterator is given a filter, before it returns the next node, it applies the
 * filter. If the filter says to accept the node, the iterator returns it;
 * otherwise, the iterator looks for the next node and pretends that the node 
 * thatwas rejected was not there.
 * <p>The DOM does not provide any filters. Filter is just an interface that 
 * userscan implement to provide their own filters. The introduction to this 
 * chaptergives an example of how a user can implement a filter to perform a 
 * specificfunction.
 * <p>Filters do not need to know how to iterate, nor do they need to know
 * anything about the data structure that is being iterated. This makes it 
 * veryeasy to write filters, since the only thing they have to know how to 
 * do isevaluate a single node. One filter may be used with a number of 
 * different kindsof iterators, encouraging code reuse.
 * <p>If a filter is installed for a TreeWalker or Iterator, the system may 
 * use that filter for various tasks, especially during fix-up. Filters 
 * should make no assumptions about how frequently they will be called.
 */
public interface NodeFilter {
  // Constants returned by acceptNode
  public static final short           FILTER_ACCEPT        = 1;
  public static final short           FILTER_REJECT        = 2;
  public static final short           FILTER_SKIP          = 3;

  /**
   * 
   * @param n The node to check to see if it passes the filter or not.
   * @return Returns a constant to determine whether the node is accepted, 
   *   rejected, or skipped, as defined above.If an exception is thrown in 
   *   this method, the results are unspecified.
   */
  public short              acceptNode(Node n);
}

