/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.fi;

import org.w3c.dom.*;

/**
 * Document contains methods that creates iterators to traverse a node and its
 * children in document order (depth first, pre-order traversal, which is
 * equivalent to the order in which the start tags occur in the text
 * representation of the document).
 */
public interface DocumentIF {
  /**
   * 
   * @param root The node which will be iterated together with its children. 
   * @param whatToShow This flag determines whether entities are expanded, and 
   *   whether comments,processing instructions, or text are presented via 
   *   the iterator. See the description of Iterator for the set of possible 
   *   values.These flags can be combined using OR:
   * <pre>
   * NodeIterator iter=doc.createNodeIterator(root, SHOW_ELEMENT | SHOW_PROCESSING_INSTRUCTION | SHOW_COMMENT | SHOW_ENTITY_REFERENCE, myFilter);</pre>
   * If SHOW_ENTITY_REFERENCE 
   *   is not set, entities are expanded. If SHOW_ENTITY_REFERENCE is set,
   *   entity references will be encountered by the iterator. There is no 
   *   setting thatshows both the entity reference and its expansion. Several 
   *   people have suggested that the functionality of whatToShow be
   *   implemented using filters. We feel that it is better to implement them 
   *   usingiterators, since it makes it possible to provide a more efficient
   *   implementation. A filter must examine each node individually; an 
   *   iterator canmake use of internal data structures to examine only those 
   *   nodes that aredesired.
   * @param filter 
   * @return The newly created NodeIterator.
   */
  public short              createNodeIterator(Node root, 
                                               short whatToShow, 
                                               NodeFilter filter);
}

