/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>EventTarget</code> interface is implemented by all 
 * <code>Node</code>s in  an implementation which supports the DOM Event 
 * Model.  The interface allows event listeners  to be registered on the node.
 */
public interface EventTarget {
  /**
   * This method allows the registration of event listeners on the event 
   * target.  
   * @param type The event type for which the user is registering
   * @param listener The <code>listener</code> parameter takes an interface 
   *   implemented by the user which contains the methods to be called when 
   *   the event occurs.
   * @param useCapture If true, <code>useCapture</code> indicates that the 
   *   user wishes to initiate capture.  After initiating capture, all events 
   *   of the specified type will be  dispatched to the registered 
   *   <code>EventListener</code> before being dispatched to any 
   *   <code>EventTarget</code>s beneath them in the tree.  Events which are 
   *   bubbling upward through the tree will not trigger an 
   *   <code>EventListener</code> designated to use capture.
   */
  public void               addEventListener(String type, 
                                             EventListener listener, 
                                             boolean useCapture);
  /**
   * This method allows the removal of event listeners from the event target.  
   * If an <code>EventListener</code> is removed from an 
   * <code>EventTarget</code> while it is  processing an event, it will 
   * complete its current actions but will not be triggered again during any 
   * later stages of event flow. 
   * @param type Specifies the event type of the <code>EventListener</code> 
   *   being removed. 
   * @param listener The <code>EventListener</code> parameter indicates the 
   *   <code>EventListener </code> to be removed. 
   * @param useCapture Specifies whether the <code>EventListener</code> being 
   *   removed is a capturing listener or not. 
   */
  public void               removeEventListener(String type, 
                                                EventListener listener, 
                                                boolean useCapture);
}

