/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>EventListener</code> interface is the primary method for handling 
 * events.  Users implement the <code>EventListener</code> interface and 
 * register their listener  on a <code>EventTarget</code> using the 
 * <code>AddEventListener</code> method.  The  users should also remove their 
 * <code>EventListener</code> from its  <code>EventTarget</code> after they 
 * have completed using the listener. 
 */
public interface EventListener {
  /**
   * This method is called whenever an event occurs of the type for which the 
   * <code> EventListener</code> interface was registered. 
   * @param event The <code>Event</code> contains contextual information about 
   *   the event.  It also contains the <code>returnValue</code> and 
   *   <code>cancelBubble</code> properties which are used in determining 
   *   proper event flow.
   */
  public void               handleEvent(Event event);
}

