/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>Event</code> interface is used to provide contextual information 
 * about an event to the handler processing the event.  An object which 
 * implements the <code>Event</code> interface is generally passed as the 
 * first parameter to an event handler.  More specific  context information 
 * is passed to event handlers by deriving additional interfaces from  
 * <code>Event</code> which contain information directly relating to the type 
 * of event they accompany.  These derived interfaces are also implemented by 
 * the object passed to the event listener. 
 */
public interface Event {
  // PhaseType
  public static final short           BUBBLING_PHASE       = 1;
  public static final short           CAPTURING_PHASE      = 2;
  public static final short           AT_TARGET            = 3;

  /**
   * The <code>type</code> property represents the event name as a string 
   * property. 
   */
  public String             getType();
  public void               setType(String type);
  /**
   * The <code>target</code> property indicates the <code>Node</code> to which 
   * the event  was originally dispatched. 
   */
  public Node               getTarget();
  public void               setTarget(Node target);
  /**
   * The <code>currentNode</code> property indicates to which <code>Node</code>
   *  the event is currently being dispatched.  This is particularly useful 
   * during capturing and bubbling. 
   */
  public Node               getCurrentNode();
  public void               setCurrentNode(Node currentNode);
  /**
   * The <code>eventPhase</code> property indicates which phase of event flow 
   * is currently  being evaluated. 
   */
  public short              getEventPhase();
  public void               setEventPhase(short eventPhase);
  /**
   * The <code>preventBubble</code> method is used to end the bubbling phase 
   * of  event flow. If this method is called by any 
   * <code>EventListener</code>s registered on the same 
   * <code>EventTarget</code> during bubbling, the bubbling phase will cease 
   * at that level and the event will not be propagated upward within the 
   * tree. 
   */
  public void               preventBubble();
  /**
   * The <code>preventCapture</code> method is used to end the capturing phase 
   * of  event flow. If this method is called by any 
   * <code>EventListener</code>s registered on the same 
   * <code>EventTarget</code> during capturing, the capturing phase will 
   * cease at that level and the event will not be propagated any further 
   * down. 
   */
  public void               preventCapture();
  /**
   * If an event is cancellable, the <code>preventCapture</code> method is used
   *  to signify that the event is to be cancelled.  If, during any stage of 
   * event flow, the <code>preventDefault</code> method is called the event 
   * is cancelled. Any default action associated with the event will not 
   * occur.  Calling this method for a non-cancellable event has no effect. 
   */
  public void               preventDefault();
}

