/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>Rect</code> interface is used to represent any  rect value. This 
 * interface reflects the values in the underlying style property. Hence, 
 * modifications made through this interface modify the style property. 
 */
public interface Rect {
  /**
   *  This attribute is used for the top of the rect. 
   */
  public CSSValue           getTop();
  public void               setTop(CSSValue top);
  /**
   *  This attribute is used for the right of the rect. 
   */
  public CSSValue           getRight();
  public void               setRight(CSSValue right);
  /**
   *  This attribute is used for the bottom of the rect. 
   */
  public CSSValue           getBottom();
  public void               setBottom(CSSValue bottom);
  /**
   *  This attribute is used for the left of the rect. 
   */
  public CSSValue           getLeft();
  public void               setLeft(CSSValue left);
}

