/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>RGBColor</code> interface is used to represent any RGB color 
 * value. This interface reflects the values in the underlying style 
 * property. Hence, modifications made through this interface modify the 
 * style property. 
 */
public interface RGBColor {
  /**
   *  This attribute is used for the red value of the RGB color. 
   */
  public CSSValue           getRed();
  public void               setRed(CSSValue red);
  /**
   *  This attribute is used for the green value of the RGB color. 
   */
  public CSSValue           getGreen();
  public void               setGreen(CSSValue green);
  /**
   *  This attribute is used for the blue value of the RGB color. 
   */
  public CSSValue           getBlue();
  public void               setBlue(CSSValue blue);
}

