/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 * The <code>CSSValueList</code> interface provides the absraction of an 
 * ordered collection of CSS values.
 */
public interface CSSValueList extends CSSValue {
  /**
   * The number of <code>CSSValue</code>s in the list. The range of valid 
   * values indices is <code>0</code> to <code>length-1</code> inclusive.
   */
  public int                getLength();
  /**
   * Used to retrieve a CSS rule by ordinal index. The order in this 
   * collection represents the order of the values in the CSS style property.
   * @param index Index into the collection.
   * @return The style rule at the <code>index</code> position in the 
   *   <code>CSSValueList</code>, or <code>null</code> if that is not valid 
   *   index.
   */
  public CSSValue           item(int index);
}

