/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>CSSValue</code> interface represents a simple or a complexe 
 * value. 
 */
public interface CSSValue {
  // UnitTypes
  public static final short           CSS_PRIMITIVE_VALUE  = 0;
  public static final short           CSS_VALUE_LIST       = 1;
  public static final short           CSS_CUSTOM           = 2;

  /**
   *  A string representation of the current value. 
   * @exception DOMException
   *   SYNTAX_ERR: Raised if the specified CSS string value has a syntax 
   *   error and is unparsable.
   *   <br>NO_MODIFICATION_ALLOWED_ERR: Raised if this declaration is 
   *   readonly.
   */
  public String             getCssText();
  public void               setCssText(String cssText)
                                 throws DOMException;
  /**
   * A code defining the type of the value as defined above.
   */
  public short              getValueType();
}

