/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>CSSRule</code> interface is the abstract base interface  for any 
 * type of CSS statement. This includes both rule sets and  at-rules. An 
 * implementation is expected to preserve all rules specified in a CSS style 
 * sheet, even if it is not recognized. Unrecognized rules are represented 
 * using the <code>CSSUnknownRule</code> interface. 
 */
public interface CSSRule {
  // RuleType
  public static final short           UNKNOWN_RULE         = 0;
  public static final short           STYLE_RULE           = 1;
  public static final short           CHARSET_RULE         = 2;
  public static final short           IMPORT_RULE          = 3;
  public static final short           MEDIA_RULE           = 4;
  public static final short           FONT_FACE_RULE       = 5;
  public static final short           PAGE_RULE            = 6;

  /**
   *  The type of the rule, as defined above. The expectation is that 
   * binding-specific casting methods can be used to cast down from an 
   * instance of the <code>CSSRule</code> interface to the specific derived 
   * interface implied by the <code>type</code>. 
   */
  public short              getType();
  /**
   *  The parsable textual representation of the rule. This reflects the 
   * current state of the rule and not its initial value. 
   * @exception DOMException
   *   SYNTAX_ERR: Raised if the specified CSS string value has a syntax 
   *   error  and is unparsable.
   *   <br>HIERARCHY_REQUEST_ERR: Raised if the rule cannot be inserted at 
   *   this point in the style sheet.
   *   <br>NO_MODIFICATION_ALLOWED_ERR: Raised if this style sheet is 
   *   readonly.
   */
  public String             getCssText();
  public void               setCssText(String cssText)
                                 throws DOMException;
  /**
   *  The style sheet that contains this rule. 
   */
  public CSSStyleSheet      getParentStyleSheet();
  /**
   *  If this rule is contained inside another rule (e.g. a style rule inside 
   * an @media block), this is the containing rule. If this rule is not 
   * nested inside any other rules, this returns <code>null</code>. 
   */
  public CSSRule            getParentRule();
}

