/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>CSSPageRule</code> interface represents a @page rule within a 
 * CSS style sheet. The <code>@page</code> rule is  used to specify the 
 * dimensions, orientation, margins, etc. of a page box for paged media. 
 */
public interface CSSPageRule extends CSSRule {
  /**
   *  The parsable textual representation of the page selector for the rule. 
   * @exception DOMException
   *   SYNTAX_ERR: Raised if the specified CSS string value has a syntax 
   *   error and is unparsable.
   *   <br>NO_MODIFICATION_ALLOWED_ERR: Raised if this style sheet is 
   *   readonly.
   */
  public String             getSelectorText();
  public void               setSelectorText(String selectorText)
                                       throws DOMException;
  /**
   *  The declaration-block of this rule. 
   */
  public CSSStyleDeclaration getStyle();
}

