/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 *  The <code>CSS2Properties</code> interface represents a convenience 
 * mechanism for retrieving and setting properties within a  
 * <code>CSSStyleDeclaration</code>. The attributes of this interface 
 * correspond to all the properties specified in CSS2. Getting an attribute 
 * of this  interface is equivalent to calling the 
 * <code>getPropertyValue</code> method of the  
 * <code>CSSStyleDeclaration</code> interface. Setting an attribute of this 
 * interface is equivalent to calling the <code>setProperty</code> method of 
 * the <code>CSSStyleDeclaration</code> interface. 
 * <p> A compliant implementation is not required to implement the 
 * <code>CSS2Properties</code> interface. If an implementation does implement 
 * this interface, the expectation is that language-specific methods can be 
 * used to cast from an instance of the  <code>CSSStyleDeclaration</code> 
 * interface to the  <code>CSS2Properties</code> interface. 
 * <p> If an implementation does implement this interface, it is expected to 
 * understand  the specific syntax of the shorthand properties, and apply 
 * their  semantics; when the <code>margin</code> property is set, for  
 * example, the <code>marginTop</code>, <code>marginRight</code>, 
 * <code>marginBottom</code> and <code>marginLeft</code> properties are 
 * actually being set by the underlying implementation. 
 * <p> When dealing with CSS "shorthand" properties, the shorthand properties 
 * should be decomposed into their component longhand properties as 
 * appropriate, and when querying for their value,  the form returned should 
 * be the shortest form exactly equivalent  to the declarations made in the 
 * ruleset.  However, if there is  no shorthand declaration that could be 
 * added to the ruleset  without changing in any way the rules already 
 * declared in the  ruleset (i.e., by adding longhand rules that were 
 * previously  not declared in the ruleset), then the empty string should be  
 * returned for the shorthand property.  
 * <p> For example, querying for the <code>font</code> property should not 
 * return "normal normal normal 14pt/normal Arial, sans-serif", when  "14pt 
 * Arial, sans-serif" suffices (the normals are initial values, and are 
 * implied by use of the longhand property). 
 * <p> If the values for all the longhand properties that compose a particular 
 * string are the initial values, then a string consisting of all the initial 
 * values should be returned (e.g.  a <code>border-width</code> value of 
 * "medium" should be returned as such, not as ""). 
 * <p> For some shorthand properties that take missing values from other 
 * sides, such as the <code>margin</code>, <code>padding</code>, and 
 * <code>border-[width|style|color]</code> properties, the minimum number of 
 * sides possible should be used, i.e., "0px 10px" will be returned instead 
 * of "0px 10px 0px 10px". 
 * <p> If the value of a shorthand property can not be decomposed into its 
 * component longhand properties, as is the case for the <code>font</code> 
 * property with a value of "menu", querying for the values of the component 
 * longhand properties should return the empty string. 
 */
public interface CSS2Properties {
  /**
   *  See the azimuth property definition in CSS2. 
   */
  public String             getAzimuth();
  public void               setAzimuth(String azimuth);
  /**
   *  See the background property definition in CSS2. 
   */
  public String             getBackground();
  public void               setBackground(String background);
  /**
   *  See the background-attachment property definition in CSS2. 
   */
  public String             getBackgroundAttachment();
  public void               setBackgroundAttachment(String backgroundAttachment);
  /**
   *  See the background-color property definition in CSS2. 
   */
  public String             getBackgroundColor();
  public void               setBackgroundColor(String backgroundColor);
  /**
   *  See the background-image property definition in CSS2. 
   */
  public String             getBackgroundImage();
  public void               setBackgroundImage(String backgroundImage);
  /**
   *  See the background-position property definition in CSS2. 
   */
  public String             getBackgroundPosition();
  public void               setBackgroundPosition(String backgroundPosition);
  /**
   *  See the background-repeat property definition in CSS2. 
   */
  public String             getBackgroundRepeat();
  public void               setBackgroundRepeat(String backgroundRepeat);
  /**
   *  See the border property definition in CSS2. 
   */
  public String             getBorder();
  public void               setBorder(String border);
  /**
   *  See the border-collapse property definition in CSS2. 
   */
  public String             getBorderCollapse();
  public void               setBorderCollapse(String borderCollapse);
  /**
   *  See the border-color property definition in CSS2. 
   */
  public String             getBorderColor();
  public void               setBorderColor(String borderColor);
  /**
   *  See the border-spacing property definition in CSS2. 
   */
  public String             getBorderSpacing();
  public void               setBorderSpacing(String borderSpacing);
  /**
   *  See the border-style property definition in CSS2. 
   */
  public String             getBorderStyle();
  public void               setBorderStyle(String borderStyle);
  /**
   *  See the border-top property definition in CSS2. 
   */
  public String             getBorderTop();
  public void               setBorderTop(String borderTop);
  /**
   *  See the border-right property definition in CSS2. 
   */
  public String             getBorderRight();
  public void               setBorderRight(String borderRight);
  /**
   *  See the border-bottom property definition in CSS2. 
   */
  public String             getBorderBottom();
  public void               setBorderBottom(String borderBottom);
  /**
   *  See the border-left property definition in CSS2. 
   */
  public String             getBorderLeft();
  public void               setBorderLeft(String borderLeft);
  /**
   *  See the border-top-color property definition in CSS2. 
   */
  public String             getBorderTopColor();
  public void               setBorderTopColor(String borderTopColor);
  /**
   *  See the border-right-color property definition in CSS2. 
   */
  public String             getBorderRightColor();
  public void               setBorderRightColor(String borderRightColor);
  /**
   *  See the border-bottom-color property definition in CSS2. 
   */
  public String             getBorderBottomColor();
  public void               setBorderBottomColor(String borderBottomColor);
  /**
   *  See the border-left-color property definition in CSS2. 
   */
  public String             getBorderLeftColor();
  public void               setBorderLeftColor(String borderLeftColor);
  /**
   *  See the border-top-style property definition in CSS2. 
   */
  public String             getBorderTopStyle();
  public void               setBorderTopStyle(String borderTopStyle);
  /**
   *  See the border-right-style property definition in CSS2. 
   */
  public String             getBorderRightStyle();
  public void               setBorderRightStyle(String borderRightStyle);
  /**
   *  See the border-bottom-style property definition in CSS2. 
   */
  public String             getBorderBottomStyle();
  public void               setBorderBottomStyle(String borderBottomStyle);
  /**
   *  See the border-left-style property definition in CSS2. 
   */
  public String             getBorderLeftStyle();
  public void               setBorderLeftStyle(String borderLeftStyle);
  /**
   *  See the border-top-width property definition in CSS2. 
   */
  public String             getBorderTopWidth();
  public void               setBorderTopWidth(String borderTopWidth);
  /**
   *  See the border-right-width property definition in CSS2. 
   */
  public String             getBorderRightWidth();
  public void               setBorderRightWidth(String borderRightWidth);
  /**
   *  See the border-bottom-width property definition in CSS2. 
   */
  public String             getBorderBottomWidth();
  public void               setBorderBottomWidth(String borderBottomWidth);
  /**
   *  See the border-left-width property definition in CSS2. 
   */
  public String             getBorderLeftWidth();
  public void               setBorderLeftWidth(String borderLeftWidth);
  /**
   *  See the border-width property definition in CSS2. 
   */
  public String             getBorderWidth();
  public void               setBorderWidth(String borderWidth);
  /**
   *  See the bottom property definition in CSS2. 
   */
  public String             getBottom();
  public void               setBottom(String bottom);
  /**
   *  See the caption-side property definition in CSS2. 
   */
  public String             getCaptionSide();
  public void               setCaptionSide(String captionSide);
  /**
   *  See the clear property definition in CSS2. 
   */
  public String             getClear();
  public void               setClear(String clear);
  /**
   *  See the clip property definition in CSS2. 
   */
  public String             getClip();
  public void               setClip(String clip);
  /**
   *  See the color property definition in CSS2. 
   */
  public String             getColor();
  public void               setColor(String color);
  /**
   *  See the content property definition in CSS2. 
   */
  public String             getContent();
  public void               setContent(String content);
  /**
   *  See the counter-increment property definition in CSS2. 
   */
  public String             getCounterIncrement();
  public void               setCounterIncrement(String counterIncrement);
  /**
   *  See the counter-reset property definition in CSS2. 
   */
  public String             getCounterReset();
  public void               setCounterReset(String counterReset);
  /**
   *  See the cue property definition in CSS2. 
   */
  public String             getCue();
  public void               setCue(String cue);
  /**
   *  See the cue-after property definition in CSS2. 
   */
  public String             getCueAfter();
  public void               setCueAfter(String cueAfter);
  /**
   *  See the cue-before property definition in CSS2. 
   */
  public String             getCueBefore();
  public void               setCueBefore(String cueBefore);
  /**
   *  See the cursor property definition in CSS2. 
   */
  public String             getCursor();
  public void               setCursor(String cursor);
  /**
   *  See the direction property definition in CSS2. 
   */
  public String             getDirection();
  public void               setDirection(String direction);
  /**
   *  See the display property definition in CSS2. 
   */
  public String             getDisplay();
  public void               setDisplay(String display);
  /**
   *  See the elevation property definition in CSS2. 
   */
  public String             getElevation();
  public void               setElevation(String elevation);
  /**
   *  See the empty-cells property definition in CSS2. 
   */
  public String             getEmptyCells();
  public void               setEmptyCells(String emptyCells);
  /**
   *  See the float property definition in CSS2. 
   */
  public String             getCssFloat();
  public void               setCssFloat(String cssFloat);
  /**
   *  See the font property definition in CSS2. 
   */
  public String             getFont();
  public void               setFont(String font);
  /**
   *  See the font-family property definition in CSS2. 
   */
  public String             getFontFamily();
  public void               setFontFamily(String fontFamily);
  /**
   *  See the font-size property definition in CSS2. 
   */
  public String             getFontSize();
  public void               setFontSize(String fontSize);
  /**
   *  See the font-size-adjust property definition in CSS2. 
   */
  public String             getFontSizeAdjust();
  public void               setFontSizeAdjust(String fontSizeAdjust);
  /**
   *  See the font-stretch property definition in CSS2. 
   */
  public String             getFontStretch();
  public void               setFontStretch(String fontStretch);
  /**
   *  See the font-style property definition in CSS2. 
   */
  public String             getFontStyle();
  public void               setFontStyle(String fontStyle);
  /**
   *  See the font-variant property definition in CSS2. 
   */
  public String             getFontVariant();
  public void               setFontVariant(String fontVariant);
  /**
   *  See the font-weight property definition in CSS2. 
   */
  public String             getFontWeight();
  public void               setFontWeight(String fontWeight);
  /**
   *  See the height property definition in CSS2. 
   */
  public String             getHeight();
  public void               setHeight(String height);
  /**
   *  See the left property definition in CSS2. 
   */
  public String             getLeft();
  public void               setLeft(String left);
  /**
   *  See the letter-spacing property definition in CSS2. 
   */
  public String             getLetterSpacing();
  public void               setLetterSpacing(String letterSpacing);
  /**
   *  See the line-height property definition in CSS2. 
   */
  public String             getLineHeight();
  public void               setLineHeight(String lineHeight);
  /**
   *  See the list-style property definition in CSS2. 
   */
  public String             getListStyle();
  public void               setListStyle(String listStyle);
  /**
   *  See the list-style-image property definition in CSS2. 
   */
  public String             getListStyleImage();
  public void               setListStyleImage(String listStyleImage);
  /**
   *  See the list-style-position property definition in CSS2. 
   */
  public String             getListStylePosition();
  public void               setListStylePosition(String listStylePosition);
  /**
   *  See the list-style-type property definition in CSS2. 
   */
  public String             getListStyleType();
  public void               setListStyleType(String listStyleType);
  /**
   *  See the margin property definition in CSS2. 
   */
  public String             getMargin();
  public void               setMargin(String margin);
  /**
   *  See the margin-top property definition in CSS2. 
   */
  public String             getMarginTop();
  public void               setMarginTop(String marginTop);
  /**
   *  See the margin-right property definition in CSS2. 
   */
  public String             getMarginRight();
  public void               setMarginRight(String marginRight);
  /**
   *  See the margin-bottom property definition in CSS2. 
   */
  public String             getMarginBottom();
  public void               setMarginBottom(String marginBottom);
  /**
   *  See the margin-left property definition in CSS2. 
   */
  public String             getMarginLeft();
  public void               setMarginLeft(String marginLeft);
  /**
   *  See the marker-offset property definition in CSS2. 
   */
  public String             getMarkerOffset();
  public void               setMarkerOffset(String markerOffset);
  /**
   *  See the marks property definition in CSS2. 
   */
  public String             getMarks();
  public void               setMarks(String marks);
  /**
   *  See the max-height property definition in CSS2. 
   */
  public String             getMaxHeight();
  public void               setMaxHeight(String maxHeight);
  /**
   *  See the max-width property definition in CSS2. 
   */
  public String             getMaxWidth();
  public void               setMaxWidth(String maxWidth);
  /**
   *  See the min-height property definition in CSS2. 
   */
  public String             getMinHeight();
  public void               setMinHeight(String minHeight);
  /**
   *  See the min-width property definition in CSS2. 
   */
  public String             getMinWidth();
  public void               setMinWidth(String minWidth);
  /**
   *  See the orphans property definition in CSS2. 
   */
  public String             getOrphans();
  public void               setOrphans(String orphans);
  /**
   *  See the outline property definition in CSS2. 
   */
  public String             getOutline();
  public void               setOutline(String outline);
  /**
   *  See the outline-color property definition in CSS2. 
   */
  public String             getOutlineColor();
  public void               setOutlineColor(String outlineColor);
  /**
   *  See the outline-style property definition in CSS2. 
   */
  public String             getOutlineStyle();
  public void               setOutlineStyle(String outlineStyle);
  /**
   *  See the outline-width property definition in CSS2. 
   */
  public String             getOutlineWidth();
  public void               setOutlineWidth(String outlineWidth);
  /**
   *  See the overflow property definition in CSS2. 
   */
  public String             getOverflow();
  public void               setOverflow(String overflow);
  /**
   *  See the padding property definition in CSS2. 
   */
  public String             getPadding();
  public void               setPadding(String padding);
  /**
   *  See the padding-top property definition in CSS2. 
   */
  public String             getPaddingTop();
  public void               setPaddingTop(String paddingTop);
  /**
   *  See the padding-right property definition in CSS2. 
   */
  public String             getPaddingRight();
  public void               setPaddingRight(String paddingRight);
  /**
   *  See the padding-bottom property definition in CSS2. 
   */
  public String             getPaddingBottom();
  public void               setPaddingBottom(String paddingBottom);
  /**
   *  See the padding-left property definition in CSS2. 
   */
  public String             getPaddingLeft();
  public void               setPaddingLeft(String paddingLeft);
  /**
   *  See the page property definition in CSS2. 
   */
  public String             getPage();
  public void               setPage(String page);
  /**
   *  See the page-break-after property definition in CSS2. 
   */
  public String             getPageBreakAfter();
  public void               setPageBreakAfter(String pageBreakAfter);
  /**
   *  See the page-break-before property definition in CSS2. 
   */
  public String             getPageBreakBefore();
  public void               setPageBreakBefore(String pageBreakBefore);
  /**
   *  See the page-break-inside property definition in CSS2. 
   */
  public String             getPageBreakInside();
  public void               setPageBreakInside(String pageBreakInside);
  /**
   *  See the pause property definition in CSS2. 
   */
  public String             getPause();
  public void               setPause(String pause);
  /**
   *  See the pause-after property definition in CSS2. 
   */
  public String             getPauseAfter();
  public void               setPauseAfter(String pauseAfter);
  /**
   *  See the pause-before property definition in CSS2. 
   */
  public String             getPauseBefore();
  public void               setPauseBefore(String pauseBefore);
  /**
   *  See the pitch property definition in CSS2. 
   */
  public String             getPitch();
  public void               setPitch(String pitch);
  /**
   *  See the pitch-range property definition in CSS2. 
   */
  public String             getPitchRange();
  public void               setPitchRange(String pitchRange);
  /**
   *  See the play-during property definition in CSS2. 
   */
  public String             getPlayDuring();
  public void               setPlayDuring(String playDuring);
  /**
   *  See the position property definition in CSS2. 
   */
  public String             getPosition();
  public void               setPosition(String position);
  /**
   *  See the quotes property definition in CSS2. 
   */
  public String             getQuotes();
  public void               setQuotes(String quotes);
  /**
   *  See the richness property definition in CSS2. 
   */
  public String             getRichness();
  public void               setRichness(String richness);
  /**
   *  See the right property definition in CSS2. 
   */
  public String             getRight();
  public void               setRight(String right);
  /**
   *  See the size property definition in CSS2. 
   */
  public String             getSize();
  public void               setSize(String size);
  /**
   *  See the speak property definition in CSS2. 
   */
  public String             getSpeak();
  public void               setSpeak(String speak);
  /**
   *  See the speak-header property definition in CSS2. 
   */
  public String             getSpeakHeader();
  public void               setSpeakHeader(String speakHeader);
  /**
   *  See the speak-numeral property definition in CSS2. 
   */
  public String             getSpeakNumeral();
  public void               setSpeakNumeral(String speakNumeral);
  /**
   *  See the speak-punctuation property definition in CSS2. 
   */
  public String             getSpeakPunctuation();
  public void               setSpeakPunctuation(String speakPunctuation);
  /**
   *  See the speech-rate property definition in CSS2. 
   */
  public String             getSpeechRate();
  public void               setSpeechRate(String speechRate);
  /**
   *  See the stress property definition in CSS2. 
   */
  public String             getStress();
  public void               setStress(String stress);
  /**
   *  See the table-layout property definition in CSS2. 
   */
  public String             getTableLayout();
  public void               setTableLayout(String tableLayout);
  /**
   *  See the text-align property definition in CSS2. 
   */
  public String             getTextAlign();
  public void               setTextAlign(String textAlign);
  /**
   *  See the text-decoration property definition in CSS2. 
   */
  public String             getTextDecoration();
  public void               setTextDecoration(String textDecoration);
  /**
   *  See the text-indent property definition in CSS2. 
   */
  public String             getTextIndent();
  public void               setTextIndent(String textIndent);
  /**
   *  See the text-shadow property definition in CSS2. 
   */
  public String             getTextShadow();
  public void               setTextShadow(String textShadow);
  /**
   *  See the text-transform property definition in CSS2. 
   */
  public String             getTextTransform();
  public void               setTextTransform(String textTransform);
  /**
   *  See the top property definition in CSS2. 
   */
  public String             getTop();
  public void               setTop(String top);
  /**
   *  See the unicode-bidi property definition in CSS2. 
   */
  public String             getUnicodeBidi();
  public void               setUnicodeBidi(String unicodeBidi);
  /**
   *  See the vertical-align property definition in CSS2. 
   */
  public String             getVerticalAlign();
  public void               setVerticalAlign(String verticalAlign);
  /**
   *  See the visibility property definition in CSS2. 
   */
  public String             getVisibility();
  public void               setVisibility(String visibility);
  /**
   *  See the voice-family property definition in CSS2. 
   */
  public String             getVoiceFamily();
  public void               setVoiceFamily(String voiceFamily);
  /**
   *  See the volume property definition in CSS2. 
   */
  public String             getVolume();
  public void               setVolume(String volume);
  /**
   *  See the white-space property definition in CSS2. 
   */
  public String             getWhiteSpace();
  public void               setWhiteSpace(String whiteSpace);
  /**
   *  See the widows property definition in CSS2. 
   */
  public String             getWidows();
  public void               setWidows(String widows);
  /**
   *  See the width property definition in CSS2. 
   */
  public String             getWidth();
  public void               setWidth(String width);
  /**
   *  See the word-spacing property definition in CSS2. 
   */
  public String             getWordSpacing();
  public void               setWordSpacing(String wordSpacing);
  /**
   *  See the z-index property definition in CSS2. 
   */
  public String             getZIndex();
  public void               setZIndex(String zIndex);
}

