/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;
import org.w3c.dom.stylesheets.*;

/**
 * The <code>CSS2Cursor</code> interface represents the cursor CSS Level 2 
 * property.
 */
public interface CSS2Cursor extends CSSValue {
  /**
   * A code defining the type of the property. It would one of 
   * <code>CSS_UNKNOWN</code> or <code>CSS_INHERIT</code>. If the type is 
   * <code>CSS_UNKNOWN</code>, then <code>uris</code> contains a list of URIs 
   * and <code>predefinedCursor</code> contains an ident. Setting this 
   * attribute from <code>CSS_INHERIT</code> to <code>CSS_UNKNOWN</code> will 
   * set the <code>predefinedCursor</code> to <code>"auto"</code>.
   */
  public short              getCursorType();
  public void               setCursorType(short cursorType);
  /**
   * <code>uris</code> represents the list of URIs (<code>CSS_URI</code>) on 
   * the cursor property. The list can be empty.
   */
  public CSSValueList       getUris();
  /**
   * This identifier represents a generic cursor name or an empty string.
   * @exception DOMException
   *   SYNTAX_ERR: Raised if the specified CSS string value has a syntax 
   *   error and is unparsable.
   *   <br>NO_MODIFICATION_ALLOWED_ERR: Raised if this declaration is 
   *   readonly.
   */
  public String             getPredefinedCursor();
  public void               setPredefinedCursor(String predefinedCursor)
                                         throws DOMException;
}

