/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom;

/**
 * The <code>Node</code> interface is extended with an additional method to 
 * test if it supports a specific feature.
 */
public interface Node2 extends Node {
  /**
   * Tests whether the DOM implementation implements a specific feature and 
   * that feature is supported by this node.
   * @param feature The package name of the feature to test. This is the same 
   *   name as what can be passed to the method <code>hasFeature</code> on 
   *   <code>DOMImplementation</code>. 
   * @param version This is the version number of the package name to test. In 
   *   Level 2, version 1, this is the string "2.0". If the version is not 
   *   specified, supporting any version of the feature will cause the method 
   *   to return <code>true</code>.
   * @return Returns <code>true</code> if this node defines a subtree within 
   *   which the specified feature is supported, <code>false</code> otherwise.
   */
  public boolean            supports(String feature, 
                                     String version);
}

