/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom;

/**
 * Two new attributes are added to the <code>DocumentType</code> interface to 
 * provide a way for retrieving the public and system identifiers
 */
public interface DocumentType2 extends DocumentType {
  /**
   * The public identifier of the document type.
   */
  public String             getPublicID();
  /**
   * The system identifier of the document type.
   */
  public String             getSystemID();
}

