/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom;

/**
 * The <code>Document</code> interface is extended with a method for importing 
 * nodes from another document.
 */
public interface Document2 extends Document {
  /**
   * Imports a node from another document to this document. The returned node 
   * has no parent (<code>parentNode</code> is <code>null</code>.).
   * <br>For all nodes, importing a node creates a node object owned by the 
   * importing document, with attribute values identical to the source node's 
   * <code>nodeName</code> and <code>nodeType</code>, plus the attributes 
   * related to namespaces (prefix and namespaces URI). As in the 
   * <code>Node.cloneNode()</code> operation, the source node is not altered.
   * <br>Additional information is copied as appropriate to the 
   * <code>nodeType</code>, attempting to mirror the behavior expected if a 
   * fragment of XML or HTML source was copied from one document to another, 
   * recognizing that the two documents may have different DTDs in the XML 
   * case. The following list describes the specifics for every type of node. 
   * ELEMENT_NODESpecified attributes nodes of the source element are 
   * imported, and the generated <code>Attr</code> nodes are attached to the 
   * generated <code>Element</code>. Default attributes are not copied, 
   * though if the document being imported into defines default attributes 
   * for this element name, those are assigned. If importNode's "deep" option 
   * was set True, the descendents of the the source element will be 
   * recursively imported and the resulting nodes reassembled to form the 
   * corresponding subtree.ATTRIBUTE_NODEThe <code>specified</code> flag is 
   * set <code>false</code> on the generated <code>Attr</code>. The 
   * descendents of the the source <code>Attr</code> are recursively imported 
   * and the resulting nodes reassembled to form the corresponding subtree.
   * Note that the <code>deep</code> parameter does not apply to 
   * <code>Attr</code> nodes, they always carry their children with them when 
   * imported.TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODEThese three types of 
   * nodes inheriting from <code>CharacterData</code> copy their 
   * <code>data</code> and <code>length</code> attributes from those of the 
   * source node.ENTITY_REFERENCE_NODEOnly the <code>EntityReference</code> 
   * itself is copied, even if a <code>deep</code> import was requested, 
   * since the source and destination documents might have defined the entity 
   * differently. If the document being imported into provides a definition 
   * for this entity name, its value is assigned.ENTITY_NODE
   * <code>Entity</code> nodes cannot be imported.PROCESSING_INSTRUCTION_NODE
   * The imported node copies its <code>target</code> and <code>data</code> 
   * values from those of the source node.DOCUMENT_NODE<code>Document</code> 
   * nodes cannot be imported.DOCUMENT_TYPE_NODE<code>DocumentType</code> 
   * nodes cannot be imported.DOCUMENT_FRAGMENT_NODEIf the <code>deep</code> 
   * option was set <code>true</code>, the descendents of the the source 
   * element will be recursively imported and the resulting nodes reassembled 
   * to form the corresponding subtree. Otherwise, this simply generates an 
   * empty <code>DocumentFragment</code>.NOTATION_NODE<code>Notation</code> 
   * nodes cannot be imported. 
   * @param importedNode The node to import.
   * @param deep If <code>true</code>, recursively import the subtree under 
   *   the specified node; if <code>false</code>, import only the node 
   *   itself, as explained above. This does not apply to <code>Attr</code> 
   *   and <code>EntityReference</code> nodes.
   * @return The imported node that belongs to this <code>Document</code>.
   */
  public Node               importNode(Node importedNode, 
                                       boolean deep);
}

