/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom;

/**
 * The <code>DOMImplementation</code> interface is extended with methods for 
 * creating an XML document instance.
 */
public interface DOMImplementation2 extends DOMImplementation {
  /**
   * Creates an empty <code>DocumentType</code> node.
   * @param name The document type name.
   * @param publicID The document type public identifier.
   * @param systemID The document type system identifier.
   * @return A new <code>DocumentType</code> node with 
   *   <code>Node.ownerDocument</code> set to <code>null</code>.
   * @exception DOMException
   *   NOT_SUPPORTED_ERR: Raised if the requested document type is not 
   *   supported.
   */
  public DocumentType       createDocumentType(String name, 
                                               String publicID, 
                                               String systemID)
                                               throws DOMException;
  /**
   * Creates an XML <code>Document</code> object of the specified type with 
   * its document element.Depending on how namespaces are supported this 
   * method may need one more parameter to hold the namespace name.
   * @param name The name of document element to be created.
   * @param doctype The type of document to be created or <code>null</code>.
   *   When <code>doctype</code> is not <code>null</code>, its 
   *   <code>Node.ownerDocument</code> attribute is set to the document being 
   *   created.
   * @return A new <code>Document</code> object.
   * @exception DOMException
   *   WRONG_DOCUMENT_ERR: Raised if <code>doctype</code> has already been 
   *   used with a different document.
   *   <br>NOT_SUPPORTED_ERR: Raised if the requested document type is not 
   *   supported.
   */
  public Document           createDocument(String name, 
                                           DocumentType doctype)
                                           throws DOMException;
}

