/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.fi;

import org.w3c.dom.*;

/**
 */
public interface NodeIterator {
  /**
   *  
   * @return The next <code>Node</code> in the set being iterated over, or 
   *   NULL if there are no more members in that set. 
   */
  public Node               nextNode();
  /**
   * Resets the iterator to the same state as a new iterator would be if 
   * constructed by the same factory method with the same arguments as used 
   * to construct this iterator.  
   */
  public void               reset();
}

