/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>UIEvent</code> interface provides specific contextual  
 * information associated with User Interface and Logical events. 
 */
public interface UIEvent extends Event {
  /**
   *  <code>screenX</code> indicates the horizontal coordinate at which the 
   * event occurred in relative to the origin of the screen coordinate system.
   *  
   */
  public int                getScreenX();
  public void               setScreenX(int screenX);
  /**
   *  <code>screenY</code> indicates the vertical coordinate at which the 
   * event occurred  relative to the origin of the screen coordinate system. 
   */
  public int                getScreenY();
  public void               setScreenY(int screenY);
  /**
   *  <code>clientX</code> indicates the horizontal coordinate at which the 
   * event occurred  relative to the DOM implementation's client area. 
   */
  public int                getClientX();
  public void               setClientX(int clientX);
  /**
   *  <code>clientY</code> indicates the vertical coordinate at which the 
   * event occurred  relative to the DOM implementation's client area. 
   */
  public int                getClientY();
  public void               setClientY(int clientY);
  /**
   *  <code>altKey</code> indicates whether the 'alt' key was depressed during 
   * the firing of the event. 
   */
  public boolean            getAltKey();
  public void               setAltKey(boolean altKey);
  /**
   *  <code>ctrlKey</code> indicates whether the 'ctrl' key was depressed 
   * during the firing of the event. 
   */
  public boolean            getCtrlKey();
  public void               setCtrlKey(boolean ctrlKey);
  /**
   *  <code>shiftKey</code> indicates whether the 'shift' key was depressed 
   * during the firing of the event. 
   */
  public boolean            getShiftKey();
  public void               setShiftKey(boolean shiftKey);
  /**
   *  The value of <code>keyCode</code> holds the virtual key code value of 
   * the key which was depressed if the event is a key event.  Otherwise, the 
   * value is zero. 
   */
  public int                getKeyCode();
  public void               setKeyCode(int keyCode);
  /**
   *  <code>charCode</code> holds the value of the Unicode character 
   * associated with the depressed key if the event is a key event.  
   * Otherwise, the value is zero. 
   */
  public int                getCharCode();
  public void               setCharCode(int charCode);
  /**
   *  During mouse events caused by the depression or release of a mouse 
   * button, <code>button</code>  is used to indicate which mouse button 
   * changed state. 
   */
  public short              getButton();
  public void               setButton(short button);
}

