/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>EventCapturer</code> interface is implemented by <code>Node</code>
 * 's which are designated as being able to capture events. 
 */
public interface EventCapturer {
  /**
   * This method is used when a capturing <code>Node</code> wishes to begin 
   * capturing a particular type of event.  
   * @param type The name of the event to be captured
   */
  public void               captureEvent(String type);
  /**
   * This method is used when a capturing <code>Node</code> wishes to cease 
   * capturing a particular type of event. 
   * @param type The name of the event to be released
   */
  public void               releaseEvent(String type);
  /**
   * This method is called during the handling of an event by a capturing 
   * <code> Node</code> to continue the event's flow to additional event 
   * handlers, or if none are present, to the event's target.  
   */
  public void               routeEvent();
}

