/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSStyleDeclaration</code> interface represents a single CSS 
 * declaration block. This interface may be used to determine the style 
 * properties currently set in a block or to set style properties explicitly 
 * within the block. 
 */
public interface CSSStyleDeclaration {
  /**
   *  The parsable textual representation of the declaration block  (including 
   * the surrounding curly braces). Setting this attribute will result in the 
   * parsing of the new value and resetting of the properties in the 
   * declaration block. 
   */
  public String             getCssText();
  public void               setCssText(String cssText);
  /**
   *  Used the retrieve the value of a CSS property if it has been explicitly 
   * set within this declaration block. 
   * @param propertyName  The name of the CSS property. See the CSS property 
   *   index. 
   * @return  Returns the value of the property if it has been explicitly set 
   *   for this declaration block. Returns the empty string if the property 
   *   has not been set or the property name does not correspondt to a valid 
   *   CSS2 property. 
   */
  public String             getPropertyValue(String propertyName);
  /**
   *   Used to retrieve the priority of a CSS property  (e.g. the 
   * <code>"!important"</code> qualifier) if the property  has been 
   * explicitly set in this declaration block. 
   * @param propertyName  The name of the CSS property. See the CSS property 
   *   index. 
   * @return  A string representing the priority (e.g. 
   *   <code>"!important"</code>) if one exists. The empty string if none 
   *   exists. 
   */
  public String             getPropertyPriority(String propertyName);
  /**
   *  Used the set a property value and priority within this declaration block.
   *  
   * @param propertyName  The name of the CSS property. See the CSS property 
   *   index. 
   * @param value  The new value of the property. 
   * @param priority  The new priority of the property (e.g. 
   *   <code>"!important"</code>).  
   * @exception DOMException
   *   SYNTAX_ERR: Raised if the specified value has a syntax error  and is 
   *   unparsable.
   */
  public void               setProperty(String propertyName, 
                                        String value, 
                                        String priority)
                                        throws DOMException;
  /**
   *  The number of properties that have been explicitly set in this 
   * declaration block. 
   */
  public int                getLength();
  /**
   *  Used to retrieve the properties that have been explicitly set in this 
   * declaration block. The order of the properties retrieved using this 
   * method does not have to be the order in which they were set. This method 
   * can be used to iterate over all properties in this declaration block. 
   * @param index  Index of the property name to retrieve. 
   * @return  The name of the property at this ordinal position. The empty 
   *   string if no property exists at this position. 
   */
  public String             item(int index);
}

