/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSRule</code> interface is the abstract base interface  for any 
 * type of CSS statement. This includes both rule sets and  at-rules. 
 */
public interface CSSRule {
  // RuleType
  public static final short           UNKNOWN_RULE         = 0;
  public static final short           STYLE_RULE           = 1;
  public static final short           IMPORT_RULE          = 2;
  public static final short           MEDIA_RULE           = 3;
  public static final short           FONT_FACE_RULE       = 4;
  public static final short           PAGE_RULE            = 5;

  /**
   *  A code defining the type of the rule, as defined above. 
   */
  public short              getType();
  /**
   *  The parsable textual representation of the rule.  
   */
  public String             getCssText();
  public void               setCssText(String cssText);
  /**
   *  The style sheet that contains this rule. 
   */
  public CSSStyleSheet      getParentStyleSheet();
}

