/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSImportRule</code> interface represents a @import rule within 
 * a CSS style sheet. The <code>@import</code> rule is used to import style 
 * rules from other style sheets.  
 */
public interface CSSImportRule extends CSSRule {
  /**
   *  The location of the style sheet to be imported. The attribute will not 
   * contain the <code>"url(...)"</code> specifier around the URI. 
   */
  public String             getHref();
  public void               setHref(String href);
  /**
   *  A comma-separated list of media types for which this style sheet may be 
   * used. 
   */
  public String             getMedia();
  public void               setMedia(String media);
  /**
   *  The style sheet referred to by this rule, if it has been loaded. The 
   * value of this attribute is null if the style sheet has not yet been  
   * loaded or if it will not be loaded (e.g. if the style sheet is for a 
   * media type not supported by the user agent). 
   */
  public CSSStyleSheet      getStyleSheet();
}

