/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.events;

import org.w3c.dom.*;

/**
 * The <code>Event</code> interface is used to provide contextual information 
 * about an event to the handler processing the event.  An object which 
 * implements the <code>Event</code> interface is generally passed as the 
 * first parameter to an event handler.  More specific  context information 
 * is passed to event handlers by deriving additional interfaces from  
 * <code>Event</code> which contain information directly relating to the type 
 * of event they accompany.  These derived interfaces are also implemented by 
 * the object passed to the event listener. 
 */
public interface Event {
  /**
   * The <code>type</code> property represents the event name as a string 
   * property. 
   */
  public String             getType();
  public void               setType(String type);
  /**
   * The <code>target</code> property indicates the <code>Node</code> to which 
   * the event  was originally dispatched. 
   */
  public Node               getTarget();
  public void               setTarget(Node target);
  /**
   * The <code>cancelBubble</code> property is used to control the bubbling 
   * phase of  event propagation. If the property is set to true, the event 
   * will cease bubbling at  the current level.  Otherwise, the event will 
   * bubble up to its parent. 
   */
  public boolean            getCancelBubble();
  public void               setCancelBubble(boolean cancelBubble);
  /**
   * If an event is cancellable, the <code>returnValue</code> property is 
   * checked by the DOM implementation  after the event has been processed by 
   * its event handlers.  If the <code>returnValue</code> is false, the DOM 
   * implementation does not execute any default actions associated with the 
   * event. 
   */
  public boolean            getReturnValue();
  public void               setReturnValue(boolean returnValue);
}

