/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 * The <code>StyleSheetCollection</code> interface provides the  abstraction 
 * of an ordered collection of style sheets. 
 */
public interface StyleSheetCollection {
  /**
   *  The length or the size of the list. 
   */
  public int                getLength();
  /**
   *  Used to retrieve a style sheet by ordinal index. 
   * @param index Index into the collection
   * @return The style sheet at the <code>index</code> position in the 
   *   <code>StyleSheetCollection</code>, or <code>null</code> if  that is 
   *   not a valid index. 
   */
  public StyleSheet         item(int index);
}

