/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 * The <code>StyleSheet</code> interface is the abstract base interface for 
 * any type of style sheet. It represents a single style sheet associated 
 * with a structured document. In HTML, the StyleSheet interface represents 
 * either an external style sheet, included via the HTML   LINK  element, or 
 * an inline  STYLE  element. In XML, this interface represents an external 
 * style sheet, included via a style sheet processing instruction . 
 */
public interface StyleSheet {
  /**
   *  This specifies the style sheet language for this style sheet. The style 
   * sheet language is specified as a content type (e.g. "text/css"). The 
   * content type is often specified in the <code>owningNode</code>. A list 
   * of registered content types can be found at 
   * ftp://ftp.isi.edu/in-notes/iana/assignments/media-types/. Also see the 
   * type attribute definition for the <code>LINK</code>  element in HTML 
   * 4.0, and the type pseudo-attribute for the XML style sheet processing 
   * instruction .  
   */
  public String             getType();
  /**
   *  <code>false</code> if the style sheet is applied to the document.  
   * <code>true</code> if it is not. 
   */
  public boolean            getDisabled();
  public void               setDisabled(boolean disabled);
  /**
   *  The node that associates this style sheet with the document. For HTML, 
   * this may be the corresponding <code>LINK</code> or <code>STYLE</code> 
   * element. For XML, it may be the linking processing instruction. For 
   * included style sheets, this attribute has a value of null. 
   */
  public Node               getOwningNode();
  /**
   * For style sheet languages that support the concept of style sheet 
   * inclusion, this attribute represents the including style sheet, if one 
   * exists. If the style sheet is a top-level style sheet, or the style 
   * sheet language does not support inclusion, the value of the attribute is 
   * null. 
   */
  public StyleSheet         getParentStyleSheet();
  /**
   *  If the style sheet is a linked style sheet, the value of its attribute 
   * is its location. For inline style sheets, the value of this attribute  
   * is null. See the href attribute definition for the <code>LINK</code> 
   * element in HTML 4.0, and the href pseudo-attribute for the XML style 
   * sheet processing instruction .  
   */
  public String             getHref();
  /**
   *  The advisory title.  The title is often specified in the 
   * <code>owningNode</code>. See the title attribute definition for the 
   * <code>LINK</code> element in HTML 4.0, and the title pseudo-attribute 
   * for the XML style sheet processing instruction .  
   */
  public String             getTitle();
  /**
   *  The intended destination medium for style information.  It may be a 
   * single media descriptor or a comma-separated list. The media is often 
   * specified in the <code>owningNode</code>. See the media attribute 
   * definition for the <code>LINK</code> element  in HTML 4.0, and the media 
   * pseudo-attribute for the XML style sheet processing instruction .  
   */
  public String             getMedia();
}

