/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSStyleRule</code> interface represents a single rule set in a 
 * CSS style sheet. 
 */
public interface CSSStyleRule extends CSSRule {
  /**
   *  The textual representation of the selector for the rule set. The 
   * implementation may have stripped out insignificant whitespace  while 
   * parsing the selector. 
   */
  public String             getSelectorText();
  public void               setSelectorText(String selectorText);
  /**
   *  The declaration-block of this rule set. 
   */
  public CSSStyleDeclaration getStyle();
}

