/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSRuleCollection</code> interface provides the  abstraction of 
 * an ordered collection of CSS rules. 
 */
public interface CSSRuleCollection {
  /**
   *  The length or the size of the list. 
   */
  public int                getLength();
  /**
   *  Used to retrieve a CSS rule by ordinal index. The order in this 
   * collection represents the order of the rules in the CSS style sheet. 
   * @param index Index into the collection
   * @return The style rule at the <code>index</code> position in the 
   *   <code>CSSRuleCollection</code>, or <code>null</code> if  that is not a 
   *   valid index. 
   */
  public CSSRule            item(int index);
}

