/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSPageRule</code> interface represents a @page rule within a 
 * CSS style sheet. The <code>@page</code> rule is  used to specify the 
 * dimensions, orientation, margins, etc. of a page box for paged media. 
 */
public interface CSSPageRule extends CSSRule {
  /**
   *  The parsable textual representation of the page selector for the rule. 
   */
  public String             getSelectorText();
  public void               setSelectorText(String selectorText);
  /**
   *  The declaration-block of this rule. 
   */
  public CSSStyleDeclaration getStyle();
}

