/*
 * Copyright (c) 1998 World Wide Web Consortium, (Massachusetts Institute of
 * Technology, Institut National de Recherche en Informatique et en
 * Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 */

package org.w3c.dom.css;

import org.w3c.dom.*;

/**
 *  The <code>CSSMediaRule</code> interface represents a @media rule in a CSS 
 * style sheet. A <code>@media</code> rule can be used to delimit style rules 
 * for specific media types. 
 */
public interface CSSMediaRule extends CSSRule {
  /**
   *  A comma-separate list of media types for this rule. This attribute does 
   * not include the <code>"@media"</code> specifier.  
   */
  public String             getMediaTypes();
  public void               setMediaTypes(String mediaTypes);
  /**
   *  A collection of all CSS rules contained within the media block. 
   */
  public CSSRuleCollection  getCssRules();
  /**
   *  Used to insert a new rule into the media block.  
   * @param rule  The parsable text representing the rule. For rule sets this 
   *   contains both the selector and the style declaration. For at-rules, 
   *   this specifies both the at-identifier and the rule content. 
   * @param index  The index within the media block's rule collection of the 
   *   rule  before which to insert the specified rule. If the  specified 
   *   index is equal to the length of the media blocks's rule collection, 
   *   the rule will be added to the end of the media block. 
   * @return  The index within the media block's rule collection of the newly 
   *   inserted rule. 
   * @exception DOMException
   *   HIERARCHY_REQUEST_ERR: Raised if the rule cannot be inserted at the 
   *   specified index. e.g. if an <code>@import</code> rule is inserted 
   *   after a standard rule set or other at-rule.
   *   <br>INDEX_SIZE_ERR: Raised if the specified index is not a valid 
   *   insertion point.
   *   <br>SYNTAX_ERR: Raised if the specified rule has a syntax error  and 
   *   is unparsable.
   */
  public int                insertRule(String rule, 
                                       int index)
                                       throws DOMException;
  /**
   *  Used to delete a rule from the media block. 
   * @param index  The index within the media block's rule collection of the 
   *   rule to remove. 
   */
  public void               deleteRule(int index);
}

