package org.w3c.dom;

public interface Node {
   // NodeType
   public static final short           DOCUMENT             = 1;
   public static final short           ELEMENT              = 2;
   public static final short           ATTRIBUTE            = 3;
   public static final short           PROCESSING_INSTRUCTION = 4;
   public static final short           COMMENT              = 5;
   public static final short           TEXT                 = 6;
   public static final short           CDATA_SECTION        = 7;
   public static final short           DOCUMENT_FRAGMENT    = 8;
   public static final short           ENTITY               = 9;
   public static final short           ENTITY_REFERENCE     = 10;
   public static final short           DOCUMENT_TYPE        = 11;

   public String             getNodeName();

   public String             getNodeValue();
   public void               setNodeValue(String arg);

   public short              getNodeType();

   public Node               getParentNode();

   public NodeList           getChildNodes();

   public Node               getFirstChild();

   public Node               getLastChild();

   public Node               getPreviousSibling();

   public Node               getNextSibling();

   public NamedNodeMap       getAttributes();

   public Node               insertBefore(Node newChild, 
                                          Node refChild)
                                          throws DOMException;
   public Node               replaceChild(Node newChild, 
                                          Node oldChild)
                                          throws DOMException;
   public Node               removeChild(Node oldChild)
                                         throws DOMException;
   public Node               appendChild(Node newChild);
   public boolean            hasChildNodes();
   public Node               cloneNode(boolean deep);
   public boolean            equals(Node arg, 
                                    boolean deep);
}

