package org.w3c.dom;

public interface Document extends DocumentFragment {
   public DocumentType       getDoctype();

   public DOMImplementation  getImplementation();

   public Element            getDocumentElement();

   public Element            createElement(String tagName);
   public DocumentFragment   createDocumentFragment();
   public Text               createTextNode(String data);
   public Comment            createComment(String data);
   public CDATASection       createCDATASection(String data);
   public ProcessingInstruction createProcessingInstruction(String target, 
                                                            String data);
   public Attribute          createAttribute(String name);
   public Entity             createEntity();
   public EntityReference    createEntityReference();
   public NodeList           getElementsByTagName(String tagname);
}

