package org.w3c.dom;

public interface Element extends Node {
   public String             getTagName();

   public String             getAttribute(String name);
   public void               setAttribute(String name, 
                                          String value)
                                          throws DOMException;
   public void               removeAttribute(String name)
                                             throws DOMException;
   public Attribute          getAttributeNode(String name);
   public Attribute          setAttributeNode(Attribute newAttr)
                                              throws DOMException;
   public Attribute          removeAttributeNode(Attribute oldAttr)
                                                 throws DOMException;
   public NodeList           getElementsByTagName(String name);
   public void               normalize();
}

