package org.w3c.dom;

public interface Document extends Node {
   public DocumentType       getDoctype();

   public DOMImplementation  getImplementation();

   public Element            getDocumentElement();

   public Element            createElement(String tagName)
                                           throws DOMException;
   public DocumentFragment   createDocumentFragment();
   public Text               createTextNode(String data);
   public Comment            createComment(String data);
   public CDATASection       createCDATASection(String data)
                                                throws DOMException;
   public ProcessingInstruction createProcessingInstruction(String target, 
                                                            String data)
                                                            throws DOMException;
   public Attribute          createAttribute(String name)
                                             throws DOMException;
   public EntityReference    createEntityReference(String name)
                                                   throws DOMException;
   public NodeList           getElementsByTagName(String tagname);
}

