<?xml version="1.0" encoding="utf-8"?>
<!-- $Id: test2html.xsl,v 1.7 2001/05/22 16:26:09 mf Exp $ -->
<!--
     $Log: test2html.xsl,v $
     Revision 1.7  2001/05/22 16:26:09  mf
     Updated from top-level makefile

     Revision 1.10  2001/05/22 15:54:21  tg127171
     Added navigation tables, added top-level testcases/@profile to test
     result IDs to disambiguate tests from multiple test suites that each
     have same test id, e.g., id="1" in both IBM and RenderX test suites.

     Revision 1.9  2001/05/16 13:48:25  tg127171
     Learnt to not put log keyword and delimiters in log messages.

     Revision 1.8  2001/05/16 13:46:57  tg127171
     Fiddled with Log keyword again.

     Revision 1.7  2001/05/16 13:42:54  tg127171
     Changed comment delimiters around Log keyword.
    
     Revision 1.6  2001/05/16 13:41:52  tg127171
     Changed to empty cell and either "Spec" or "Test" instead of "no" and
     "yes" for specproblem and testproblem.  Capitalised "Full" and
     "Issues".  Made "Full" white instead of black on green background.

     revision 1.5  2001/05/16 12:32:41  mf
     checked in with -k by tg127171 at 2001/05/16 13:29:50

     revision 1.4  2001/05/16 10:59:06  tg127171
     Added more <a> anchors.  Now translate spaces in ids into '-'.

     revision 1.3  2001/05/15 18:54:04  tg127171
     Took great liberties with test report formatting and then had to take
     minor liberties with test case formatting to match.

     revision 1.2  2001/05/15 18:13:04  tg127171
     Minor modifications to add ids in a few places.  Also added report of
     testproblem attribute.

     revision 1.1  2001/05/15 17:49:13  tg127171
     Initial revision
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="html" indent="no" encoding="ISO-8859-1"/>

  <!-- Common navigation table component -->
  <xsl:template name="nav-table">
    <xsl:param name="up-id"/>
    <xsl:param name="top-id"/>

    <xsl:if test="$up-id or $top-id">
      <table align="right">
        <tr>
          <td align="right">
            <xsl:if test="$up-id">
              <xsl:text/>[<a href="#{$up-id}">Up</a>]<xsl:text/>
            </xsl:if>
            <xsl:if test="$top-id">
              <xsl:text/> [<a href="#{$top-id}">Top</a>]<xsl:text/>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:variable name="title">
    <xsl:text/>XSL Test Suite: <xsl:value-of select="testsuite/@profile"/>
  </xsl:variable>

  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:value-of select="$title"/>
        </title>
        <style type="text/css">
          body { background-color: white}
          h2 { background-color: yellow}
        </style>
      </head>
      <body>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="testsuite">
    <xsl:variable name="testsuite-id"
      select="translate(@profile, ' ', '-')"/>
    <h1>
      <a name="{$testsuite-id}">
        <xsl:value-of select="$title"/>
      </a>
    </h1>
    <table>
      <xsl:apply-templates>
        <xsl:with-param name="testsuite-id" select="$testsuite-id"/>
      </xsl:apply-templates>
    </table>
  </xsl:template>

  <xsl:template match="testcases">
    <xsl:variable name="my-testcases-id"
      select="translate(normalize-space(@profile), ' ', '-')"/>
    <xsl:param name="testsuite-id"/>
    <xsl:param name="top-testcases-id"
      select="$my-testcases-id"/>
    <tr>
      <td colspan="6">
        <xsl:call-template name="nav-table">
          <xsl:with-param name="top-id" select="$testsuite-id"/>
        </xsl:call-template>
        <h2>
          <a name="{$my-testcases-id}">
            <xsl:text/>Test Cases: <xsl:value-of select="@profile"/>
          </a>
        </h2>
      </td>
    </tr>

    <xsl:apply-templates>
      <xsl:with-param name="testsuite-id" select="$testsuite-id"/>
      <xsl:with-param name="top-testcases-id" select="$top-testcases-id"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="test">
    <tr>
      <td>
    <h3>
      <a name="test-{translate(@id, ' ', '-')}">
        <xsl:text>Test #</xsl:text>
        <xsl:value-of select="@id"/>
      </a>
    </h3>

    <xsl:if test="node()">
      <p><xsl:apply-templates/></p>
    </xsl:if>

    <ul>
      <li>Formatting Object: <xsl:value-of select="@fo"/></li>

      <xsl:if test="@property">
        <li>Property: <xsl:value-of select="@property"/></li>
      </xsl:if>

      <li>XML file: 
      <a>
        <xsl:attribute name="href">
          <xsl:if test="../@base">
            <xsl:value-of select="../@base"/>
            <xsl:text>/</xsl:text>
          </xsl:if>
          <xsl:value-of select="@xml"/>
        </xsl:attribute><xsl:value-of select="@xml"/>
      </a>
      </li>

      <xsl:if test="@xsl">
        <li>Stylesheet: 
          <a>
            <xsl:attribute name="href">
              <xsl:if test="../@base">
                <xsl:value-of select="../@base"/>
                <xsl:text>/</xsl:text>
              </xsl:if>
              <xsl:value-of select="@xsl"/>
            </xsl:attribute>
            <xsl:value-of select="@xsl"/>
          </a>
        </li>
      </xsl:if>

      <xsl:if test="@results">      
      <li>
        <xsl:text>Expected result: </xsl:text>
        <a>
          <xsl:attribute name="href">
            <xsl:if test="../@base">
              <xsl:value-of select="../@base"/>
              <xsl:text>/</xsl:text>
            </xsl:if>
            <xsl:value-of select="@results"/>
          </xsl:attribute>
          <xsl:value-of select="@results"/>
        </a>
      </li>
      </xsl:if>
    </ul>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="testresult">
    <xsl:param name="testsuite-id"/>
    <xsl:param name="top-testcases-id"/>
    <xsl:variable name="testresult-id"
      select="concat('result-', $top-testcases-id, '-', translate(normalize-space(@id), ' ', '-'))"/>
    <tr>
      <td>
        <a name="{$testresult-id}">
          <xsl:value-of select="@id"/>
        </a>
      </td>
      <td>
        <a>
          <xsl:attribute name="href">
            <xsl:if test="ancestor::testcases/@base">
              <xsl:value-of select="ancestor::testcases/@base"/>
              <xsl:text>/</xsl:text>
            </xsl:if>
            <xsl:value-of select="@results"/>
          </xsl:attribute>
          <xsl:value-of select="@results"/>
        </a>
      </td>
      <td>
        <table border="1" width="100%">
          <tr>
            <td align="center" width="33%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@agreement = 'full'">
                    <xsl:text/>green</xsl:when>
                  <xsl:otherwise>red</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@agreement = 'full'">
                  <span style="color: white">Full</span>
                </xsl:when>
                <xsl:otherwise>Issues</xsl:otherwise>
              </xsl:choose>
            </td>
            <td align="center" width="33%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@specproblem = 'yes'">
                    <xsl:text/>yellow</xsl:when>
                  <xsl:otherwise>white</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@specproblem = 'yes'">
                  <xsl:text/>Spec</xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
            <td align="center" width="33%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@testproblem = 'yes'">
                    <xsl:text/>yellow</xsl:when>
                  <xsl:otherwise>white</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@testproblem = 'yes'">
                  <xsl:text/>Test</xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>
      </td>
      <td>
        <xsl:copy-of select="*|text()"/>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
