<?xml version="1.0" encoding="utf-8"?>
<!-- XSL Test Suite Test Coverage Summary stylesheet -->
<!-- $Id: testcoverage.xsl,v 1.7 2001/08/27 11:04:20 mf Exp $ -->

<!-- Author: Tony Graham <Tony.Graham@Sun.com> -->
<!-- Created: 30 April 2001 -->
<!-- Version: $Revision: 1.7 $ -->
<!--
     $Log: testcoverage.xsl,v $
     Revision 1.7  2001/08/27 11:04:20  mf
     Updated from top-level makefile

     Revision 1.6  2001/06/18 11:42:33  mf
     new stylesheets

     Revision 1.5  2001/06/15 10:22:10  tg127171
     Changed all <td align="right"> to <td style="text-align: right"> since
     only style attribute overrides style in CSS class definition.  Totals for
     each result type in "Test Result Files" table now right-aligned.

     Revision 1.4  2001/06/05 14:01:55  tg127171
     Revised test coverage categories, removed categorising code to
     separate coverage.xsl that is also used by results2html.xsl.

     Revision 1.5  2001/05/23 12:29:23  mf
     no change

     Revision 1.4  2001/05/22 16:26:06  mf
     Updated from top-level makefile

     Revision 1.3  2001/05/22 15:50:32  tg127171
     Factored navigation table into "nav-table" named template, added count
     of full, problem, and issue results to table of result sets,
     disambiguated reporting results and linking to tests with same id from
     different profile.  Probably still have an inaccuracy with total
     coverage count because of duplicate IDs but can't yet work out how to
     solve it using a single XPath expression.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:include href="coverage.xsl"/>

  <xsl:output method="html" indent="no" encoding="ISO-8859-1"/>

  <!-- XML file containing list of filenames -->
  <xsl:param name="testsuites"/>

  <!-- Location of "home page" for entire test suite -->
  <xsl:param name="home" select="'../index.html'"/>

  <!-- Names of test case files.
       This could be the root nodes of the test case files to reduce the
       number of times this stylesheet uses document(), but the file names
       are copied to the output, so the file names are cached then both
       copied to the output and used in document() in multiple places.
  -->
  <xsl:variable name="testsuite-files"
    select="document($testsuites)/testsuites/testsuite/@href"/>

  <!-- All tests in all test suites -->
  <xsl:variable name="total-tests"
    select="document($testsuite-files)//test"/>

  <!-- The number of tests in all test suites -->
  <xsl:variable name="total-test-count"
    select="count($total-tests)"/>

  <!-- Node-set of root nodes of result files -->
  <xsl:variable name="result-files"
    select="testsuites/testsuite/@href"/>

  <!-- Key relating result file URLs and document nodes -->
  <xsl:key name="result-files"
    match="testsuites/testsuite/@href"
    use="document(.)"/>

  <!-- Number of result files -->
  <xsl:variable name="result-files-count"
    select="count($result-files)"/>

  <!-- Width to use when making HTML tables showing results -->
  <xsl:variable name="result-cell-width"
    select="format-number(1 div $result-files-count, '##0%')"/>

  <!-- All test results from all test results files -->
  <xsl:variable name="all-test-results"
    select="document($result-files)/testsuite/testcases//testresult"/>

  <!-- The number of results in all test results -->
  <xsl:variable name="total-result-count"
    select="count($total-tests/@id[$all-test-results/@id = .])"/>

  <!-- Output page title -->
  <xsl:variable name="title">XSL CR Test Suite -- Test Coverage</xsl:variable>

  <!-- Common navigation table component -->
  <xsl:template name="nav-table">
    <xsl:param name="up"/>
    <xsl:param name="top"/>
    <xsl:param name="home"/>

    <xsl:if test="$up or $top or $home">
      <table align="right">
        <tr>
          <td style="text-align: right">
            <xsl:if test="$up">
              <xsl:text/>[<a href="{$up}">Up</a>]<xsl:text/>
            </xsl:if>
            <xsl:if test="$top">
              <xsl:text/> [<a href="{$top}">Top</a>]<xsl:text/>
            </xsl:if>
            <xsl:if test="$home">
              <xsl:text/> [<a href="{$home}">Home</a>]<xsl:text/>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template match="/">
    <html>
      <head>
        <title><xsl:value-of select="$title"/></title>
        <style type="text/css">
          body { background-color: white}
          h2 { background-color: yellow}
          <xsl:call-template name="coverage-styles"/>
        </style>
      </head>
      <body bgcolor="#FFFFFF">

        <xsl:call-template name="nav-table">
          <xsl:with-param name="home" select="$home"/>
        </xsl:call-template>

        <h1><a name="top"><xsl:value-of select="$title"/></a></h1>

        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <ul>
          <li><a href="#introduction">Introduction</a></li>
          <li><a href="#result-files">Test Result Files</a>: Details of
          the test result files covered by this report</li>
          <li><a href="#total-coverage">Total Test Coverage</a>:
          Summary of the number of tests, number of tests with
          results, and the percentage of test cases covered by those
          results</li>
          <li><a href="#test-suites">Coverage of Individual Test
          Suites</a>: Per-test suite summary of tests, tests
          with results, and the corresponding percentage of tests
          covered by those
          results</li>
          <li><a href="#test-coverage">Test Coverage</a>: Indication
          of the test result reported in each test result file for each test
          in the test suites</li>
        </ul>

        <h2><a name="introduction">Introduction</a></h2>

        <p>This report tabulates the coverage of a set of test result files
        over a set of test case files for the test suite for the XSL Candidate
        Recommendation.</p>

        <p>The agreement between an individual
        test result and the expected result as described in the test
        case is categorized as follows:</p>

        <!-- Get the coverage category summary table from the separate
             coverage module -->
        <xsl:call-template name="coverage-summary-table"/>

        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <h2><a name="result-files">Test Result Files</a></h2>

        <table border="1">
          <tr>
            <th rowspan="2">Profile</th>
            <th rowspan="2">File</th>
            <th colspan="6">Test Results</th>
          </tr>
          <tr>
            <th class="full">Full</th>
            <th class="future">Future</th>
            <th class="differ">Differ</th>
            <th class="test">Test</th>
            <th class="spec">Spec</th>
            <th>Total</th>
          </tr>

          <xsl:for-each select="testsuites/testsuite/@href">
            <!-- Cache the external file in case the XSLT processor is
                 inefficient about multiple document() calls to the same
                 document
            -->
            <xsl:variable name="result-testsuite"
              select="document(.)/testsuite"/>
            <tr>
              <td><xsl:value-of select="$result-testsuite/@profile"/></td>
              <td>
                <xsl:value-of select="."/>
                <xsl:text> [</xsl:text>
                <a href="{substring-before(., '.xml')}.html">HTML</a>
                <xsl:text>]</xsl:text>
              </td>
              <td style="text-align: right">
                <xsl:value-of select="count($result-testsuite//testresult[@agreement = 'full' and @specproblem = 'no' and @testproblem = 'no'])"/>
              </td>
              <td style="text-align: right">
                <!-- <xsl:value-of select="count($result-testsuite//testresult[@futuresupport = 'full' or @futuresupport = 'partial'])"/> -->
                <xsl:value-of select="count($result-testsuite//testresult[@agreement = 'issues' and @specproblem = 'no' and @testproblem = 'no' and (@futuresupport = 'full' or @futuresupport = 'partial')])"/>
              </td>
              <td style="text-align: right">
                <!--                <xsl:value-of select="count($result-testsuite//testresult[@agreement = 'issues' and @specproblem = 'no' and @testproblem = 'no'])"/> -->
                <xsl:value-of select="count($result-testsuite//testresult[@agreement = 'issues' and @specproblem = 'no' and @testproblem = 'no' and not(@futuresupport = 'full' or @futuresupport = 'partial')])"/>
              </td>
              <td style="text-align: right">
                <xsl:value-of select="count($result-testsuite//testresult[@testproblem = 'yes'])"/>
              </td>
              <td style="text-align: right">
                <xsl:value-of select="count($result-testsuite//testresult[@specproblem = 'yes'])"/>
              </td>
              <td style="text-align: right">
                <xsl:value-of select="count($result-testsuite//testresult)"/>
              </td>
            </tr>
          </xsl:for-each>
          <tr>
            <th colspan="2" style="text-align: right">Total</th>
              <td class="full" style="text-align: right">
                <xsl:value-of select="count($all-test-results[@agreement = 'full' and @specproblem = 'no' and @testproblem = 'no'])"/>
              </td>
              <td class="future" style="text-align: right">
                <xsl:value-of select="count($all-test-results[@agreement = 'issues' and @specproblem = 'no' and @testproblem = 'no' and (@futuresupport = 'full' or @futuresupport = 'partial')])"/>
              </td>
              <td class="differ" style="text-align: right">
                <xsl:value-of select="count($all-test-results[@agreement = 'issues' and @specproblem = 'no' and @testproblem = 'no' and not(@futuresupport = 'full' or @futuresupport = 'partial')])"/>
              </td>
              <td class="test" style="text-align: right">
                <xsl:value-of select="count($all-test-results[@testproblem = 'yes' and @specproblem = 'no'])"/>
              </td>
              <td class="spec" style="text-align: right">
                <xsl:value-of select="count($all-test-results[@specproblem = 'yes'])"/>
              </td>
              <td style="text-align: right">
                <xsl:value-of select="count($all-test-results)"/>
              </td>
            </tr>
        </table>

        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <h2><a name="total-coverage">Total Test Coverage</a></h2>

        <table border="1">
          <tr>
            <th>Test Cases</th>
            <th>Tests with Results</th>
            <th>Coverage</th>
          </tr>
          <tr>
            <td align="center">
              <xsl:value-of select="$total-test-count"/>
            </td>
            <td align="center">
              <xsl:value-of select="$total-result-count"/>
            </td>
            <td align="center">
              <xsl:value-of
                select="format-number($total-result-count div $total-test-count,
                        '##0.#%')"/>
            </td>
          </tr>
        </table>

        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <h2>
          <a name="test-suites">Coverage of Individual Test Suites</a>
        </h2>

        <table border="1">
          <tr>
            <th rowspan="2">Profile</th>
            <th rowspan="2">File</th>
            <th colspan="2">Test Cases</th>
            <th colspan="2">Tests with Results</th>
            <th rowspan="2">Profile Coverage</th>
          </tr>
          <tr>
            <th>Count</th>
            <th>% of Total</th>
            <th>Count</th>
            <th>% of Total</th> 
         </tr>
          <xsl:for-each select="$testsuite-files">
            <!-- Cache the external file in case the XSLT processor is
                 inefficient about multiple document() calls to the same
                 document
            -->
            <xsl:variable name="testsuite"
              select="document(.)/testsuite"/>
            <!-- All of the tests in the test suite -->
            <xsl:variable name="testsuite-tests"
              select="$testsuite//test"/>
            <!-- The number of tests in the test suite -->
            <xsl:variable name="test-count" select="count($testsuite-tests)"/>
            <!-- The number of results for tests in the test suite -->
            <xsl:variable name="result-count"
              select="count($testsuite-tests/@id[$all-test-results/@id = .])"/>
            <tr>
              <td>
                <a href="#tc-{generate-id(.)}">
                  <xsl:value-of select="$testsuite/@profile"/>
                </a>
              </td>
              <td><xsl:value-of select="."/></td>
              <td align="center">
                <xsl:value-of select="$test-count"/>
              </td>
              <td align="center">
                <xsl:value-of
                  select="format-number($test-count div $total-test-count,
                          '##0.#%')"/>
              </td>
              <td align="center">
                <xsl:value-of select="$result-count"/>
              </td>
              <td align="center">
                <xsl:value-of
                  select="format-number($result-count div $total-result-count,
                          '##0.#%')"/>
              </td>
              <td align="center">
                <xsl:value-of
                  select="format-number($result-count div $test-count,
                          '##0.#%')"/>
              </td>
            </tr>
          </xsl:for-each>
        </table>

        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <h1><a name="test-coverage">Test Coverage</a></h1>

        <p>This section shows the test results for each test in the
        test case files.</p>
        <p>The test cases are grouped by test suite, in the same
        order as the test suites are listed in the <a
        href="#test-suites">Coverage of Individual Test Suites</a> table. The heading for each test suite 
        shows its profile followed by the parenthesised filename of
        the XML file describing the test suite that was used as input
        when generating this report.</p>
        <p>Within each test suite, the tests are grouped by their
        "testcase" collection. The test cases appear in the same order
        as in the XML document describing the test suite.</p>
        <p>The information for individual tests is the test's ID, its
        description, and a table indicating the result
        reported by each of the result files that were used as input
        when generating this report.</p>
        <p>Each test id links to that test's summary in the HTML file
        produced from the test suite's XML file.</p>
        <p>The results table for each test has <xsl:value-of
        select="$result-files-count"/> columns, one for each of the
        result files used as input. The columns for each result file
        are in the same order as the result files are listed
        in the <a href="#result-files">Test Results Files</a> table.</p>

        <p>Each test result entry links to that test's result summary in
        the HTML file produced from the test result's XML file.</p>

        <h2>Test Suites:</h2>
        <ul>
          <xsl:for-each select="$testsuite-files">
            <xsl:variable name="testsuite"
              select="document(.)/testsuite"/>
            <xsl:variable name="testsuite-id"
              select="concat('tc-', generate-id(.))"/>
            <li>
              <a href="#{$testsuite-id}">
                <xsl:value-of select="$testsuite/@profile"/>
              </a>
            </li>
          </xsl:for-each>
        </ul>

        <xsl:for-each select="$testsuite-files">
        <!-- Cache the external file in case the XSLT processor is
             inefficient about multiple document() calls to the same
             document
             -->
          <xsl:variable name="testsuite"
            select="document(.)/testsuite"/>
          <xsl:variable name="testsuite-profile"
            select="normalize-space($testsuite/@profile)"/>
          <xsl:variable name="testsuite-id"
            select="concat('tc-', generate-id(.))"/>
          <xsl:variable name="testsuite-html-href"
            select="concat(substring-before(., '.xml'), '.html')"/>
          <hr width="50%" align="center"/>

          <xsl:call-template name="nav-table">
            <xsl:with-param name="up" select="'#test-coverage'"/>
            <xsl:with-param name="top" select="'#top'"/>
          </xsl:call-template>

          <h2>
            <a class="testsuite"
              name="{$testsuite-id}"
              href="{$testsuite-html-href}">
              <xsl:text>Test Suite: </xsl:text>
              <xsl:value-of select="$testsuite/@profile"/>
            </a>
            <xsl:text> (</xsl:text>
            <xsl:value-of select="."/>
            <xsl:text>)</xsl:text>
          </h2>

          <ul>
            <xsl:apply-templates select="$testsuite/testcases" mode="ts-toc"/>
          </ul>

          <table>
            <xsl:apply-templates select="$testsuite/testcases">
              <xsl:with-param name="up" select="concat('#', $testsuite-id)"/>
              <xsl:with-param name="testsuite-html-href"
                select="$testsuite-html-href"/>
              <xsl:with-param name="testsuite-profile"
                select="$testsuite-profile"/>
            </xsl:apply-templates>
          </table>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="testcases" mode="ts-toc">
    <li>
      <a href="#tc-{generate-id(.)}">
        <xsl:value-of select="@profile"/>
      </a>
      <xsl:if test="testcases">
        <ul>
          <xsl:apply-templates select="testcases" mode="ts-toc"/>
        </ul>
      </xsl:if>
    </li>
  </xsl:template>

  <xsl:template match="testcases">
    <xsl:param name="up"/>
    <xsl:param name="testsuite-html-href"/>
    <xsl:param name="testsuite-profile"/>
    <xsl:variable name="testcase-id"
      select="concat('tc-', generate-id(.))"/>
    <tr>
      <td colspan="3">

        <xsl:call-template name="nav-table">
          <xsl:with-param name="up" select="$up"/>
          <xsl:with-param name="top" select="'#top'"/>
        </xsl:call-template>

        <h2>
          <a class="testsuite"
            name="{$testcase-id}"
            href="{$testsuite-html-href}#{translate(@profile, ' ', '-')}">
            <xsl:text/>Test Cases: <xsl:value-of select="@profile"/>
          </a>
        </h2>
      </td>
    </tr>

    <!-- Only output the test result name table if there are child test
         elements. -->
    <xsl:if test="test">
      <tr>
        <td colspan="2">&#160;</td>
        <td>
          <table width="100%" border="1">
            <tr>
              <xsl:for-each select="$result-files">
                <td align="center" width="{$result-cell-width}">
                  <xsl:value-of select="document(.)/testsuite/@profile"/>
                </td>
              </xsl:for-each>
            </tr>
          </table>
        </td>
      </tr>
    </xsl:if>

    <!-- Process children, which should be test and testcases elements -->
    <xsl:apply-templates>
      <xsl:with-param name="up" select="concat('#', $testcase-id)"/>
      <xsl:with-param name="testsuite-html-href"
        select="$testsuite-html-href"/>
      <xsl:with-param name="testsuite-profile" select="$testsuite-profile"/>
    </xsl:apply-templates>
  </xsl:template>

  <!-- For each test, add a row to the table.  The row contains info about
       the test plus a table summarizing the result reported from each
       test result set. -->
  <xsl:template match="test">
    <xsl:param name="testsuite-html-href"/>
    <xsl:param name="testsuite-profile"/>

    <xsl:variable name="id" select="normalize-space(@id)"/>
    <xsl:variable name="id-href" select="translate(concat($testsuite-profile, '-', @id), ' ', '-')"/>
    <tr>
      <td valign="top" width="10%">
        <a class="testsuite"
          href="{$testsuite-html-href}#test-{translate($id, ' ', '-')}">
          <xsl:value-of select="$id"/>
        </a>
      </td>
      <!-- There may be HTML-style markup in the content of the test, so
           copy the child text and elements to the result tree -->
      <td valign="top" width="40%"><xsl:copy-of select="text() | *"/></td>
      <td valign="top">
        <table width="100%" border="1">
          <tr>
            <xsl:for-each select="$result-files">
              <!-- Multiple test suites use the same ID, e.g., id="1", so
                   use only the result that has the same top-level profile
                   name and the same ID as the current test.  The top level
                   in the test suite is <testsuite>, but the same profile
                   appears on a <testcases> in the result set.  Result
                   sets cover multiple test suites while still using the
                   same markup scheme as individual test suites, so result
                   sets have a <testsuite> for the result set and have to
                   demote the <testsuite> elements of the test suites that
                   they cover to <testcases> elements in order for the result
                   sets to fit the test suite DTD. -->
              <xsl:variable name="result"
                select="document(.)/testsuite/testcases[@profile = $testsuite-profile]//testresult[normalize-space(@id) = $id]"/>

              <xsl:call-template name="coverage-cell">
                <xsl:with-param name="width" select="$result-cell-width"/>
                <xsl:with-param name="result" select="$result"/>
                <xsl:with-param name="result-html-href"
                  select="concat(substring-before(., '.xml'),
                          '.html#result-',
                          $id-href)"/>
                <xsl:with-param name="result-cell-width"
                  select="$result-cell-width"/>
              </xsl:call-template>
            </xsl:for-each>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
