<?xml version="1.0" encoding="utf-8"?>
<!-- $Id: results2html.xsl,v 1.1 2001/06/19 10:06:22 mf Exp $ -->
<!--
     $Log: results2html.xsl,v $
     Revision 1.1  2001/06/19 10:06:22  mf
     updated

     Revision 1.1  2001/06/05 14:03:02  tg127171
     Initial revision

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:include href="../coverage/coverage.xsl"/>

  <xsl:output method="html" indent="no" encoding="ISO-8859-1"/>

  <xsl:param name="home" select="'../../index.html'"/>

  <!-- Common navigation table component -->
  <xsl:template name="nav-table">
    <xsl:param name="up"/>
    <xsl:param name="top"/>
    <xsl:param name="home"/>

    <xsl:if test="$up or $top or $home">
      <table align="right">
        <tr>
          <td align="right">
            <xsl:if test="$up">
              <xsl:text/>[<a href="{$up}">Up</a>]<xsl:text/>
            </xsl:if>
            <xsl:if test="$top">
              <xsl:text/> [<a href="{$top}">Top</a>]<xsl:text/>
            </xsl:if>
            <xsl:if test="$home">
              <xsl:text/> [<a href="{$home}">Home</a>]<xsl:text/>
            </xsl:if>
          </td>
        </tr>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:variable name="title">
    <xsl:text/>XSL Test Suite: <xsl:value-of select="testsuite/@profile"/>
  </xsl:variable>

  <xsl:template match="/">
    <html>
      <head>
        <title>
          <xsl:value-of select="$title"/>
        </title>
        <style type="text/css">
          body { background-color: white}
          h2 { background-color: yellow}
          <xsl:call-template name="coverage-styles"/>
        </style>
      </head>
      <body>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="testsuite">
    <xsl:variable name="testsuite-id"
      select="translate(@profile, ' ', '-')"/>

    <xsl:call-template name="nav-table">
      <xsl:with-param name="home" select="$home"/>
    </xsl:call-template>

    <h1>
      <a name="{$testsuite-id}">
        <xsl:value-of select="$title"/>
      </a>
    </h1>

    <ul>
      <li><a href="#introduction">Introduction</a></li>
      <li><a href="#testresults">Test Results</a></li>
    </ul>

    <h2><a name="introduction">Introduction</a></h2>

    <p>This report tabulates the reported results from
    <xsl:value-of select="count(testcases)"/> test suites for one
    XSL processor.</p>

    <p>The following information is reported for each test result:</p>

    <table border="1">
      <tr>
        <th>ID</th>
        <td>The ID of the test case within the test suite</td>
      </tr>
      <tr>
        <th>Result</th>
        <td>Name of the test result file.  This is also a link to the
        file.</td>
      </tr>
      <tr>
        <th>Coverage</th>
        <td>The test result status as reported in the test coverage summary:

          <!-- Get the coverage category summary table from the separate
               coverage module -->
          <xsl:call-template name="coverage-summary-table"/>

          <p>The coverage status is determined from the "Agree", "Future",
          "Test", and "Spec" attributes of the test result.</p>
        </td>
      </tr>
      <tr>
        <th>Agree</th>
        <td>Agreement between the test result and the expected result
        provided by the test suite creator
          <table border="1">
            <tr>
              <td bgcolor="green" style="color: white" align="center">Full</td>
              <td>Full agreement with the expected results as described in
              the test case</td>
            </tr>
            <tr>
              <td bgcolor="yellow" align="center">Issues</td>
              <td>Less than full agreement with the expected results</td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Future</th>
        <td>Expected future support of the feature tested by this
        test case:
          <table border="1">
            <tr>
              <td bgcolor="palegreen" align="center">Full</td>
              <td>Full support is expected</td>
            </tr>
            <tr>
              <td bgcolor="palegreen" align="center">Partial</td>
              <td>Partial support is expected</td>
            </tr>
            <tr>
              <td bgcolor="white">&#160;</td>
              <td>No expectation of future support was reported</td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Test</th>
        <td>Indication whether there is any issue with the test case and
        the expected result it suggests, especially if the results of the
        test differ as that given as "expected" by the test case but are,
        in fact, believed to be the correct results
          <table border="1">
            <tr>
              <td bgcolor="orange" align="center">Test</td>
              <td>There is an issue with the test case</td>
            </tr>
            <tr>
              <td bgcolor="white">&#160;</td>
              <td>No test issue was reported</td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Spec</th>
        <td>Indication whether there is any ambiguity or other problem
        found in the spec that relates to this test, especially if the
        results weren't as expected because of a misinterpretation of the
        spec
          <table border="1">
            <tr>
              <td bgcolor="red" align="center">Spec</td>
              <td>There is an issue with the spec</td>
            </tr>
            <tr>
              <td bgcolor="white">&#160;</td>
              <td>No spec issue was reported</td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <th>Further info</th>
        <td>Description of the results of the test and any issues or further
        information</td>
      </tr>
    </table>

    <h2><a name="testresults">Test Results</a></h2>

    <ul>
      <xsl:for-each select="testcases">
        <li>
          <a href="#{translate(normalize-space(@profile), ' ', '-')}">
            <xsl:value-of select="@profile"/>
          </a>
        </li>
      </xsl:for-each>
    </ul>

    <xsl:apply-templates>
      <xsl:with-param name="top" select="concat('#', $testsuite-id)"/>
    </xsl:apply-templates>
  </xsl:template>

  <!-- In test result files, <testcases> children of <testsuite> each
       correspond to a different testsuit file -->
  <xsl:template match="testsuite/testcases">
    <xsl:variable name="my-testcases-id"
      select="translate(normalize-space(@profile), ' ', '-')"/>
    <xsl:param name="top"/>

    <hr width="50%" align="center"/>
    <xsl:call-template name="nav-table">
      <xsl:with-param name="top" select="$top"/>
    </xsl:call-template>
    <h2>
      <a name="{$my-testcases-id}">
        <xsl:text/>Test Suite: <xsl:value-of select="@profile"/>
      </a>
    </h2>

    <ul>
      <xsl:apply-templates select="testcases" mode="ts-toc"/>
    </ul>

    <table width="100%">
    <!-- Descendant <testcases> and <testresult> elements each add
         a row to the table -->
      <xsl:apply-templates>
        <xsl:with-param name="top" select="$top"/>
        <xsl:with-param name="up" select="concat('#', $my-testcases-id)"/>
        <!-- Need to track the ID of the top-level testcases element
             since that corresponds to the individual test suite, and
             test results are disambiguated by their test suite ID -->
        <xsl:with-param name="top-testcases-id" select="$my-testcases-id"/>
      </xsl:apply-templates>
    </table>

  </xsl:template>

  <xsl:template match="testcases">
    <xsl:variable name="my-testcases-id"
      select="translate(normalize-space(@profile), ' ', '-')"/>
    <xsl:param name="up"/>
    <xsl:param name="top"/>
    <xsl:param name="top-testcases-id"/>
    <tr>
      <td colspan="6">
        <hr width="50%" align="center"/>
        <xsl:call-template name="nav-table">
          <xsl:with-param name="top" select="$top"/>
          <xsl:with-param name="up" select="$up"/>
        </xsl:call-template>
        <h2>
          <a name="{$my-testcases-id}">
            <xsl:text/>Test Cases: <xsl:value-of select="@profile"/>
          </a>
        </h2>
      </td>
    </tr>

    <tr>
      <td colspan="6">
        <ul>
          <xsl:apply-templates select="testcases" mode="ts-toc"/>
        </ul>
      </td>
    </tr>

    <!-- Only output the test result name table if there are child testresult
         elements. -->
    <xsl:if test="testresult">
      <tr>
        <th align="left">ID</th>
        <th align="left">Result</th>
        <td>
          <table width="100%">
            <tr>
              <th>Coverage</th>
            </tr>
          </table>
        </td>
        <td>
          <table width="100%">
            <tr>
              <th align="center" width="25%">Agree</th>
              <th align="center" width="25%">Future</th>
              <th align="center" width="25%">Test</th>
              <th align="center" width="25%">Spec</th>
          </tr>
        </table>
      </td>
        <th align="left">Further info</th>
      </tr>
    </xsl:if>

    <xsl:apply-templates>
      <xsl:with-param name="top" select="$top"/>
      <xsl:with-param name="up" select="concat('#', $my-testcases-id)"/>
      <xsl:with-param name="top-testcases-id" select="$top-testcases-id"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="testcases" mode="ts-toc">
    <xsl:variable name="my-testcases-id"
      select="translate(normalize-space(@profile), ' ', '-')"/>
    <li>
      <a href="#{$my-testcases-id}">
        <xsl:value-of select="@profile"/>
      </a>
      <xsl:if test="testcases">
        <ul>
          <xsl:apply-templates select="testcases" mode="ts-toc"/>
        </ul>
      </xsl:if>
    </li>
  </xsl:template>


  <!-- If there are any tests in the test result file, don't add anything
       to the result for any test -->
  <xsl:template match="test"/>

  <!-- Result of an individual test -->
  <xsl:template match="testresult">
    <xsl:param name="testsuite-id"/>
    <xsl:param name="top"/>
    <xsl:param name="top-testcases-id"/>
    <xsl:variable name="testresult-id"
      select="concat('result-', $top-testcases-id, '-', translate(normalize-space(@id), ' ', '-'))"/>
    <tr>
      <td>
        <a name="{$testresult-id}">
          <xsl:value-of select="@id"/>
        </a>
      </td>
      <td>
        <a>
          <xsl:attribute name="href">
            <xsl:if test="ancestor::testcases/@base">
              <xsl:value-of select="ancestor::testcases/@base"/>
              <xsl:text>/</xsl:text>
            </xsl:if>
            <xsl:value-of select="@results"/>
          </xsl:attribute>
          <xsl:value-of select="@results"/>
        </a>
      </td>
      <td>
        <table border="1" width="100%">
          <tr>
            <xsl:call-template name="coverage-cell">
              <xsl:with-param name="result" select="."/>
            </xsl:call-template>
          </tr>
        </table>
      </td>
      <td>
        <table border="1" width="100%">
          <tr>
            <td align="center" width="25%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@agreement = 'full'">
                    <xsl:text/>green</xsl:when>
                  <xsl:otherwise>yellow</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@agreement = 'full'">
                  <span style="color: white">Full</span>
                </xsl:when>
                <xsl:otherwise>Issues</xsl:otherwise>
              </xsl:choose>
            </td>
            <td align="center" width="25%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@futuresupport = 'full' or
                                  @futuresupport = 'partial'">
                    <xsl:text/>palegreen</xsl:when>
                  <xsl:otherwise>white</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                  <xsl:when test="@futuresupport = 'full'">
                    <span style="color: white">Full</span>
                  </xsl:when>
                  <xsl:when test="@futuresupport = 'partial'">
                    <xsl:text/>Partial</xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
            <td align="center" width="25%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@testproblem = 'yes'">
                    <xsl:text/>orange</xsl:when>
                  <xsl:otherwise>white</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@testproblem = 'yes'">
                  <xsl:text/>Test</xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
            <td align="center" width="25%">
              <xsl:attribute name="bgcolor">
                <xsl:choose>
                  <xsl:when test="@specproblem = 'yes'">
                    <xsl:text/>red</xsl:when>
                  <xsl:otherwise>white</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
              <xsl:choose>
                <xsl:when test="@specproblem = 'yes'">
                  <xsl:text/>Spec</xsl:when>
                <xsl:otherwise>&#160;</xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </table>
      </td>
      <td>
        <xsl:copy-of select="*|text()"/>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
