<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:import href="test2html.xsl"/>

  <xsl:output method="html" indent="no" encoding="ISO-8859-1"/>

  <!-- XML file containing list of filenames -->
  <xsl:param name="testsuites"/>

  <!-- Names of test case files -->
  <xsl:variable name="testsuite-files"
    select="document($testsuites)/testsuites/testsuite/@href"/>

  <!-- All tests in all test suites -->
  <xsl:variable name="total-tests"
    select="document($testsuite-files)//test"/>

  <!-- The number of tests in all test suites -->
  <xsl:variable name="total-test-count"
    select="count($total-tests)"/>

  <!-- Node-set of root nodes of result files -->
  <xsl:variable name="result-files"
    select="document(testsuites/testsuite/@href)"/>

  <!-- All test results from all test results files -->
  <xsl:variable name="all-test-results"
    select="$result-files/testsuite/testcases//testresult"/>

  <!-- The number of results in all test results -->
  <xsl:variable name="total-result-count"
    select="count($total-tests/@id[$all-test-results/@id = .])"/>

  <!-- Output page title -->
  <xsl:variable name="title">XSL CR Test Suite -- Tests with no matching results</xsl:variable>

  <xsl:template match="/">
    <html>
      <head>
        <title><xsl:value-of select="$title"/></title>
        <style type="text/css">
          body { background-color: white}
          h2 { background-color: yellow}
        </style>
      </head>
      <body bgcolor="#FFFFFF">
        <h1><xsl:value-of select="$title"/></h1>


        <h2>Introduction</h2>
        <p>This report tabulates the tests from the test suite for the
        XSL Candidate Recommendation that do not have test results
        reported in the set of test result files that were used as
        input for this report.</p>
        <p>This report has the following sections:</p>
        <ul>
          <li>Introduction: This section</li>
          <li><a href="#result-files">Test Result Files</a>: Details of
          the test result files covered by this report</li>
          <li><a href="#total-coverage">Total Test Coverage</a>:
          Summary of the number of tests, number of tests with
          results, and the percentage of test cases covered by those
          results</li>
          <li><a href="#test-suites">Coverage of Individual Test
          Suites</a>: Per-test suite summary of tests, tests
          with results, and the corresponding percentage of tests
          covered by those
          results</li>
          <li><a href="#not-covered">Tests Not Covered by Test
          Results</a>: List of the tests from each test suite that
          are not covered by test results in the test result
          files</li>
        </ul>

        <h2><a name="result-files">Test Result Files</a></h2>
        <table border="1">
          <tr>
            <th>Profile</th>
            <th>File</th>
            <th>Test Results</th>
          </tr>
          <xsl:for-each select="testsuites/testsuite/@href">
            <!-- Cache the external file in case the XSLT processor is
                 inefficient about multiple document() calls to the same
                 document
            -->
            <xsl:variable name="result-testsuite"
              select="document(.)/testsuite"/>
            <tr>
              <td><xsl:value-of select="$result-testsuite/@profile"/></td>
              <td><xsl:value-of select="."/></td>
              <td align="left">
                <xsl:value-of select="count($result-testsuite//testresult)"/>
              </td>
            </tr>
          </xsl:for-each>
        </table>

        <h2><a name="total-coverage">Total Test Coverage</a></h2>
        <table border="1">
          <tr>
            <th>Test Cases</th>
            <th>Tests with Results</th>
            <th>Coverage</th>
          </tr>
          <tr>
            <td align="left">
              <xsl:value-of select="$total-test-count"/>
            </td>
            <td align="left">
              <xsl:value-of select="$total-result-count"/>
            </td>
            <td align="left">
              <xsl:value-of
                select="format-number($total-result-count div $total-test-count,
                        '##0.#%')"/>
            </td>
          </tr>
        </table>

        <h2><a name="test-suites">Coverage of Individual Test Suites</a></h2>
        <table border="1">
          <tr>
            <th>Profile</th>
            <th>File</th>
            <th>Test Cases</th>
            <th>Tests with Results</th>
            <th>Coverage</th>
          </tr>
          <xsl:for-each select="$testsuite-files">
            <!-- Cache the external file in case the XSLT processor is
                 inefficient about multiple document() calls to the same
                 document
            -->
            <xsl:variable name="testsuite"
              select="document(.)/testsuite"/>
            <!-- All of the tests in the test suite -->
            <xsl:variable name="testsuite-tests"
              select="$testsuite//test"/>
            <!-- The number of tests in the test suite -->
            <xsl:variable name="test-count" select="count($testsuite-tests)"/>
            <!-- The number of results for tests in the test suite -->
            <xsl:variable name="result-count"
              select="count($testsuite-tests/@id[$all-test-results/@id = .])"/>
            <tr>
              <td>
                <a href="#tc-{generate-id(.)}">
                  <xsl:value-of select="$testsuite/@profile"/>
                </a>
              </td>
              <td><xsl:value-of select="."/></td>
              <td align="left">
                <xsl:value-of select="$test-count"/>
              </td>
              <td align="left">
                <xsl:value-of select="$result-count"/>
              </td>
              <td align="left">
                <xsl:value-of
                  select="format-number($result-count div $test-count,
                          '##0.#%')"/>
              </td>
            </tr>
          </xsl:for-each>
        </table>

        <h1><a name="not-covered">Tests Not Covered By Test Results</a></h1>

        <p>This section shows the test results for each test in the
        test case files.</p>
        <p>The test cases are grouped by test suite, in the same
        order as the test suites are listed in the <a
        href="#test-suites">Coverage of Individual Test Suites</a>
        table. The heading for each test suite 
        shows its profile followed by the parenthesised filename of
        the XML file describing the test suite that was used as input
        when generating this report.</p>
        <p>Within each test suite, the tests are grouped by their
        "testcase" collection. The test cases appear in the same order
        as in the XML document describing the test suite.</p>
        <p>The information for individual tests is the same as the
        test's description on the W3C web site.</p>

        <xsl:for-each select="$testsuite-files">
          <!-- Cache the external file in case the XSLT processor is
               inefficient about multiple document() calls to the same
               document
          -->
          <xsl:variable name="testsuite"
            select="document(.)/testsuite"/>
          <h2>
            <a name="tc-{generate-id(.)}">
              <xsl:text>Test Suite: </xsl:text>
              <xsl:value-of select="$testsuite/@profile"/>
              <xsl:text> (</xsl:text>
              <xsl:value-of select="."/>
              <xsl:text>)</xsl:text>
            </a>
          </h2>
          <xsl:apply-templates select="$testsuite/testcases"/>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="testcases">
    <xsl:variable name="tests-with-no-results"
      select="test[not($all-test-results/@id = @id)]"/>
    <h2>Test Cases: <xsl:value-of select="@profile"/></h2>
    <xsl:if test="test and not($tests-with-no-results)">
      <p>All tests covered by available test results</p>
    </xsl:if>
    <xsl:apply-templates
      select="test[not($all-test-results/@id = @id)] | testcases"/>
  </xsl:template>

</xsl:stylesheet>
