<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:strip-space elements="*"/>

<xsl:include href="format.xsl"/>

<xsl:template match="alternate-set">
  <fo:multi-switch>
     <xsl:apply-templates/>
  </fo:multi-switch>
</xsl:template>

<xsl:template match="alternate">
  <fo:multi-case>
     <xsl:attribute name="case-name">
       <xsl:value-of select="@name"/>
     </xsl:attribute>
     <xsl:if test="position()=1">
       <xsl:attribute name="starting-state">
         <xsl:text>show</xsl:text>
       </xsl:attribute>
     </xsl:if>
     <xsl:apply-templates/>
  </fo:multi-case>
</xsl:template>

<xsl:template match="selector">
  <fo:multi-toggle>
     <xsl:attribute name="switch-to">
       <xsl:value-of select="@target"/>
     </xsl:attribute>
     <xsl:apply-templates/>
  </fo:multi-toggle>
</xsl:template>

<xsl:template match="image">
  <fo:block>
     <fo:external-graphic>
       <xsl:attribute name="src">
         <xsl:value-of select="@src"/>
       </xsl:attribute>
     </fo:external-graphic>
  </fo:block>
</xsl:template>

<xsl:attribute-set name="block-attributes">
   <xsl:attribute name="font-size">12pt</xsl:attribute>
   <xsl:attribute name="line-stacking-strategy">line-height</xsl:attribute>
   <xsl:attribute name="padding-start">5px</xsl:attribute>
   <xsl:attribute name="padding-end">5px</xsl:attribute>
   <xsl:attribute name="border-before-style">solid</xsl:attribute>
   <xsl:attribute name="border-before-width">medium</xsl:attribute>
   <xsl:attribute name="border-before-color">blue</xsl:attribute>
   <xsl:attribute name="border-after-style">solid</xsl:attribute>
   <xsl:attribute name="border-after-width">medium</xsl:attribute>
   <xsl:attribute name="border-after-color">blue</xsl:attribute>
   <xsl:attribute name="border-start-style">solid</xsl:attribute>
   <xsl:attribute name="border-start-width">medium</xsl:attribute>
   <xsl:attribute name="border-start-color">blue</xsl:attribute>
   <xsl:attribute name="border-end-style">solid</xsl:attribute>
   <xsl:attribute name="border-end-width">medium</xsl:attribute>
   <xsl:attribute name="border-end-color">blue</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="button-attributes">
   <xsl:attribute name="padding-start">5px</xsl:attribute>
   <xsl:attribute name="padding-end">5px</xsl:attribute>
   <xsl:attribute name="border-before-style">outset</xsl:attribute>
   <xsl:attribute name="border-before-width">thick</xsl:attribute>
   <xsl:attribute name="border-before-color">green</xsl:attribute>
   <xsl:attribute name="border-after-style">outset</xsl:attribute>
   <xsl:attribute name="border-after-width">thick</xsl:attribute>
   <xsl:attribute name="border-after-color">green</xsl:attribute>
   <xsl:attribute name="border-start-style">outset</xsl:attribute>
   <xsl:attribute name="border-start-width">thick</xsl:attribute>
   <xsl:attribute name="border-start-color">green</xsl:attribute>
   <xsl:attribute name="border-end-style">outset</xsl:attribute>
   <xsl:attribute name="border-end-width">thick</xsl:attribute>
   <xsl:attribute name="border-end-color">green</xsl:attribute>
   <xsl:attribute name="background-color">aqua</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="text">
  <fo:block
    xsl:use-attribute-sets="block-attributes">
    <xsl:attribute name="background-color">white</xsl:attribute>
    <xsl:attribute name="font-family">SanSerif</xsl:attribute>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="text[@rendering='pretty']">
  <fo:block
    xsl:use-attribute-sets="block-attributes">
    <xsl:attribute name="background-color">yellow</xsl:attribute>
    <xsl:attribute name="color">blue</xsl:attribute>
    <xsl:attribute name="font-family">Palatino, serif</xsl:attribute>
    <xsl:attribute name="font-style">bold</xsl:attribute>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="selector//text">
  <fo:block
    xsl:use-attribute-sets="button-attributes">
    <xsl:attribute name="font-family">Palatino, Sanserif</xsl:attribute>
    <xsl:attribute name="font-style">bold</xsl:attribute>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<!--
<xsl:template match="text()">
  <fo:block
    xsl:use-attribute-sets="block-attributes">
    <xsl:attribute name="background-color">white</xsl:attribute>
    <xsl:value-of select="."/>
  </fo:block>
</xsl:template>
-->
</xsl:stylesheet>
