<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:strip-space elements="*"/>

<xsl:include href="format.xsl"/>

<xsl:template match="link">
  <fo:block>
    <fo:multi-properties>
       <fo:multi-property-set active-state="link" color="blue" border-after-color="blue"/>
       <fo:multi-property-set active-state="visited" color="fuchsia" border-after-color="fuchsia"/>
       <fo:wrapper color="merge-property-values()" border-after-color="merge-property-values()">
         <fo:basic-link border-after-style="solid" border-after-width="thin">
            <xsl:attribute name="internal-destination">
               <xsl:value-of select="@ref"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </fo:basic-link>
       </fo:wrapper>
    </fo:multi-properties>
  </fo:block>
</xsl:template>

<xsl:template match="text">
  <fo:block>
    <xsl:copy-of select="@id"/>
    <xsl:attribute name="background-color">white</xsl:attribute>
    <xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="padding-start">5px</xsl:attribute>
    <xsl:attribute name="padding-end">5px</xsl:attribute>
    <xsl:attribute name="border-before-style">solid</xsl:attribute>
    <xsl:attribute name="border-before-width">medium</xsl:attribute>
    <xsl:attribute name="border-before-color">blue</xsl:attribute>
    <xsl:attribute name="border-after-style">solid</xsl:attribute>
    <xsl:attribute name="border-after-width">medium</xsl:attribute>
    <xsl:attribute name="border-after-color">blue</xsl:attribute>
    <xsl:attribute name="border-start-style">solid</xsl:attribute>
    <xsl:attribute name="border-start-width">medium</xsl:attribute>
    <xsl:attribute name="border-start-color">blue</xsl:attribute>
    <xsl:attribute name="border-end-style">solid</xsl:attribute>
    <xsl:attribute name="border-end-width">medium</xsl:attribute>
    <xsl:attribute name="border-end-color">blue</xsl:attribute>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

</xsl:stylesheet>
