<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns="http://www.w3.org/1999/xhtml"
>

<xsl:output method="xml"
  omit-xml-declaration="no" encoding="ISO-8859-1"/>

<xsl:param name="line-stacking-strategy">max-height</xsl:param>

<xsl:template match="/">
  <fo:root line-stacking-strategy="{$line-stacking-strategy}" hyphenate="true" language='en'>
    <fo:layout-master-set>

      <fo:simple-page-master master-name="title-page"
                             page-height="11in"
                             page-width="8.5in"
                             margin-left="1.5in"
                             margin-right="1.5in"
                             margin-top="50pt"
                             margin-bottom="50pt">
        <fo:region-body margin-bottom="25pt"
                        margin-top="25pt"/>
      </fo:simple-page-master>

      <fo:simple-page-master master-name="front-page"
                             page-height="11in"
                             page-width="8.5in"
                             margin-left="1.5in"
                             margin-right="1.5in"
                             margin-top="50pt"
                             margin-bottom="50pt">
        <fo:region-body margin-bottom="25pt"
                        margin-top="25pt"/>
        <fo:region-after extent="25pt"/>
      </fo:simple-page-master>

      <fo:simple-page-master master-name="body-recto-page"
                             page-height="11in"
                             page-width="8.5in"
                             margin-left="1.5in"
                             margin-right="1in"
                             margin-top="50pt"
                             margin-bottom="50pt">
        <fo:region-body margin-bottom="25pt"
                        margin-top="25pt" column-count="2"/>
        <fo:region-before extent="25pt"/>
        <fo:region-after extent="25pt"/>
      </fo:simple-page-master>

      <fo:simple-page-master master-name="body-verso-page"
                             page-height="11in"
                             page-width="8.5in"
                             margin-left="1in"
                             margin-right="1.5in"
                             margin-top="50pt"
                             margin-bottom="50pt">
        <fo:region-body margin-bottom="25pt"
                        margin-top="25pt" column-count="2"/>
        <fo:region-before extent="25pt"/>
        <fo:region-after extent="25pt"/>
      </fo:simple-page-master>

      <fo:page-sequence-master master-name="front">
        <fo:single-page-master-reference master-name="title-page"/>
        <fo:repeatable-page-master-reference master-name="front-page"/>
      </fo:page-sequence-master>

      <fo:page-sequence-master master-name="body">
        <fo:repeatable-page-master-alternatives>
          <fo:conditional-page-master-reference 
		master-name="body-recto-page" odd-or-even="odd"/>
          <fo:conditional-page-master-reference 
		master-name="body-verso-page" odd-or-even="even"/>
        </fo:repeatable-page-master-alternatives>
      </fo:page-sequence-master>

    </fo:layout-master-set>
    <xsl:apply-templates/>
  </fo:root>
</xsl:template>

<xsl:template match="img[@src]">
  <fo:external-graphic src="{@src}">
   <xsl:if test="not(@height or @width)">
     <xsl:attribute name="width">50%</xsl:attribute>
     <xsl:attribute name="content-width">scale-to-fit</xsl:attribute>
   </xsl:if>
    <xsl:if test="@height">
      <xsl:attribute name="content-height">
        <xsl:value-of select="@height"/>px
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@width">
      <xsl:attribute name="content-width">
        <xsl:value-of select="@width"/>px
      </xsl:attribute>
    </xsl:if>
  </fo:external-graphic>
</xsl:template>

<xsl:template match="b">
  <fo:inline font-weight="bold">
    <xsl:apply-templates/>
  </fo:inline>
</xsl:template>

<xsl:template match="blockquote">
  <fo:block margin-left="24pt" margin-right="24pt" font-size="10pt" line-height="12pt"
      space-before.optimum="6pt" space-before.minimum="4pt" space-before.maximum="10pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="blockquote[@class='note']">
  <fo:block margin-left="24pt" margin-right="24pt" font-weight="bold"
      space-before.optimum="6pt" space-before.minimum="4pt" space-before.maximum="10pt"
      keep-with-next="always" text-align="center">NOTE:</fo:block>
  <fo:block margin-left="24pt" margin-right="24pt" 
      space-before="4pt" space-before.precedence="2"
      space-after="6pt" space-after.precedence="2">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="body">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="code">
  <fo:inline font-family="monospace" font-size="0.9em">
    <xsl:apply-templates/>
  </fo:inline>
</xsl:template>

<xsl:template match="div">
  <fo:block> <!-- section div -->
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div[@class='titlepage']">
  <fo:block font-family="sans-serif" text-align="center">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div[@class='front']">
  <fo:page-sequence master-name="front" font-family="serif"
         font-size="12pt" line-height="13pt" format="i">
   <fo:static-content flow-name="xsl-region-after">
     <fo:block text-align="center">
       <xsl:text>- </xsl:text><fo:page-number/><xsl:text> -</xsl:text>
     </fo:block>
   </fo:static-content>
   <fo:flow flow-name="xsl-region-body">
    <xsl:apply-templates/>
    <fo:block font-family="sans-serif" line-height="14pt" break-before="page">
      <fo:block font-weight="bold" space-before="12pt"
          space-after="10pt" keep-with-next="always">
        <xsl:text>Contents</xsl:text>
      </fo:block>
      <fo:wrapper text-align="start" text-align-last="justify">
        <xsl:apply-templates select="//div/h2|//div/h3|//div/h4" mode="toc"/>
      </fo:wrapper>
    </fo:block>
   </fo:flow>
  </fo:page-sequence>
</xsl:template>

<xsl:template match="div[@class='body']">
  <fo:page-sequence master-name="body" font-family="serif"
         font-size="12pt" line-height="13pt" initial-page-number="1">
   <fo:static-content flow-name="xsl-region-before">
     <fo:block last-line-end-indent="0pt" font-size="8pt" text-align-last="justify">
       <xsl:text>More Complex XSL FO Test Document</xsl:text>
       <fo:leader 
               leader-length.minimum="0.5in" leader-length.optimum="0.5in"
               keep-with-previous="always" keep-with-next="always"/>
       <fo:retrieve-marker retrieve-class-name="divtitle"/>
     </fo:block>
   </fo:static-content>
   <fo:static-content flow-name="xsl-region-after">
     <fo:block text-align="center">
       <fo:page-number/>
     </fo:block>
   </fo:static-content>
   <fo:flow flow-name="xsl-region-body">
     <xsl:apply-templates/>
   </fo:flow>
  </fo:page-sequence>
</xsl:template>

<xsl:template match="div[@class='chapter']">
  <fo:block break-before="page">
    <fo:block span="all" font-size="16pt" line-height="18pt" font-family="sans-serif" 
            font-weight="bold" space-after="10pt" keep-with-next="always"
            text-align="center">
      <xsl:attribute name="id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
      <xsl:apply-templates select="h3" mode="chaphead"/>
    </fo:block>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div[@class='abstract']">
  <fo:block font-size="12pt" line-height="12pt" font-family="sans-serif" font-weight="bold" 
      space-after="10pt" break-before="odd-page" keep-with-next="always">
    <xsl:text>Abstract</xsl:text>
  </fo:block>
  <fo:block margin-left="12pt" font-size="10pt" line-height="11pt" font-family="sans-serif">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="h1">
  <fo:block font-family="sans-serif" text-align="left" 
      font-weight="bold" font-size="20pt" line-height="20pt" 
      space-before.optimum="60pt" space-after.optimum="48pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h2">
  <fo:block font-family="sans-serif" text-align="left" 
      font-weight="bold" font-size="16pt" line-height="16pt" 
      space-before.minimum="12pt" space-before.optimum="16pt" space-before.maximum="20pt"
      space-after.minimum="10pt" space-after.optimum="12pt" space-after.maximum="16pt"
      keep-with-next="always">
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h2" mode="toc">
  <fo:block space-before="6pt" end-indent="24pt" last-line-end-indent="-24pt"
            start-indent="36pt" text-indent="-36pt">
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots"
               leader-length.minimum="2.5in" leader-length.optimum="2.5in"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="h3">
  <fo:block font-family="sans-serif" space-after="24pt"
      text-align="left" font-size="16pt" line-height="16pt" space-before="24pt" 
      space-before.precedence="2">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h3">
  <!-- do nothing as this is handle in div[@class='chapter'] -->
</xsl:template>

<xsl:template match="h3" mode="chaphead">
  <fo:block>
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h3" mode="toc">
  <fo:block space-before="3pt" end-indent="24pt" last-line-end-indent="-24pt"
            start-indent="36pt" text-indent="-36pt">
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots" 
               leader-length.minimum="2.5in" leader-length.optimum="2.5in"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="div[@class='titlepage']/h3" mode="toc">
</xsl:template>

<xsl:template match="div/h4">
  <fo:block font-family="serif" text-align="left" 
      font-weight="bold" font-size="12pt" line-height="12pt" 
      space-before.minimum="6pt" space-before.optimum="8pt" space-before.maximum="12pt"
      space-after.minimum="3pt" space-after.optimum="4pt" space-after.maximum="6pt"
      space-after.precedence="2"
      keep-with-next="always">
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <fo:marker marker-class-name="divtitle">
      <xsl:apply-templates/>
    </fo:marker>
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h4" mode="toc">
  <fo:block end-indent="24pt" last-line-end-indent="-24pt"
            start-indent="36pt" text-indent="-36pt">
    <xsl:number level="multiple" count="div[not(@class) or @class = 'chapter']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots"
               leader-length.minimum="2.5in" leader-length.optimum="2.5in"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="em">
  <fo:inline font-style="italic">
    <xsl:apply-templates/>
  </fo:inline>
</xsl:template>

<xsl:template match="head">
</xsl:template>

<xsl:template match="html">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="p">
  <fo:block text-align="justify"
      space-before.minimum="4pt" space-before.optimum="6pt" space-before.maximum="9pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="p[@class='graphic']">
  <fo:block text-align="center"
      space-before.minimum="6pt" space-before.optimum="8pt" space-before.maximum="12pt"
      space-before.precedence="3"
      space-after.minimum="6pt" space-after.optimum="8pt" space-after.maximum="12pt"
      space-after.precedence="3">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="li/p[1]" priority="2">
  <fo:block text-align="justify">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="li/p[position()>1]" priority="1">
  <fo:block text-align="justify">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<!-- =========== Code from Anders for lists (modified) =============== -->
<xsl:attribute-set name="ol">
  <xsl:attribute name="margin-left">1.33em</xsl:attribute>
  <xsl:attribute name="provisional-distance-between-starts">20pt</xsl:attribute>
  <xsl:attribute name="provisional-label-separation">5pt</xsl:attribute>
  <xsl:attribute name="keep-with-previous">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="nested_ol">
  <xsl:attribute name="margin-left">0pt</xsl:attribute>
  <xsl:attribute name="provisional-distance-between-starts">20pt</xsl:attribute>
  <xsl:attribute name="provisional-label-separation">5pt</xsl:attribute>
  <xsl:attribute name="keep-with-previous">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ol_li_label">
  <xsl:attribute name="end-indent">label-end()</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ol_li_body">
  <xsl:attribute name="start-indent">body-start()</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ul">
  <xsl:attribute name="margin-left">1.33em</xsl:attribute>
  <xsl:attribute name="provisional-distance-between-starts">15pt</xsl:attribute>
  <xsl:attribute name="provisional-label-separation">5pt</xsl:attribute>
  <xsl:attribute name="keep-with-previous">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="nested_ul">
  <xsl:attribute name="margin-left">0pt</xsl:attribute>
  <xsl:attribute name="provisional-distance-between-starts">15pt</xsl:attribute>
  <xsl:attribute name="provisional-label-separation">5pt</xsl:attribute>
  <xsl:attribute name="keep-with-previous">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ul_li_label">
  <xsl:attribute name="end-indent">label-end()</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="ul_li_body">
  <xsl:attribute name="start-indent">body-start()</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="ol">
  <fo:list-block xsl:use-attribute-sets="ol"
      space-before.minimum="3pt" space-before.optimum="5pt" space-before.maximum="8pt"
      space-after.minimum="3pt" space-after.optimum="5pt" space-after.maximum="8pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ol//ol">
  <fo:list-block xsl:use-attribute-sets="nested_ol"
      space-before.minimum="3pt" space-before.optimum="5pt" space-before.maximum="8pt"
      space-after.minimum="3pt" space-after.optimum="5pt" space-after.maximum="8pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ol/li">
  <xsl:variable name="ol-numbering-index" select="count(ancestor::ol) mod 3"/>
  <fo:list-item>
    <fo:list-item-label xsl:use-attribute-sets="ol_li_label">
      <fo:block>
        <xsl:choose>
          <xsl:when test="$ol-numbering-index = 1">
            <xsl:number format="1."/>
          </xsl:when>
          <xsl:when test="$ol-numbering-index = 2">
            <xsl:number format="a."/>
          </xsl:when>
          <xsl:when test="$ol-numbering-index = 0">
            <xsl:number format="i."/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ERR</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </fo:block><xsl:text>
</xsl:text>
    </fo:list-item-label>
    <fo:list-item-body xsl:use-attribute-sets="ol_li_body">
      <fo:block>
        <xsl:apply-templates/>
      </fo:block>
    </fo:list-item-body><xsl:text>
</xsl:text>
  </fo:list-item><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="ul">
  <fo:list-block xsl:use-attribute-sets="ul"
      space-before.minimum="3pt" space-before.optimum="5pt" space-before.maximum="8pt"
      space-after.minimum="3pt" space-after.optimum="5pt" space-after.maximum="8pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ul//ul">
  <fo:list-block xsl:use-attribute-sets="nested_ul"
      space-before.minimum="3pt" space-before.optimum="5pt" space-before.maximum="8pt"
      space-after.minimum="3pt" space-after.optimum="5pt" space-after.maximum="8pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template name="ul_li_label_mark">
  <xsl:param name="ul-numbering-index" select="4"/>
      <fo:block>
        <xsl:choose>
          <xsl:when test="$ul-numbering-index = 1">
            <xsl:text>&#x2022;</xsl:text> <!-- bullet -->
          </xsl:when>
          <xsl:when test="$ul-numbering-index = 2">
            <xsl:text>o</xsl:text> <!-- open circle -->
          </xsl:when>
          <xsl:when test="$ul-numbering-index = 0">
            <xsl:text>&#x2013;</xsl:text> <!-- ndash -->
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>ERR</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </fo:block><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="ul/li">
  <xsl:variable name="ul-numbering-index" select="count(ancestor::ul) mod 3"/>
  <fo:list-item>
    <fo:list-item-label xsl:use-attribute-sets="ul_li_label">
      <xsl:call-template name="ul_li_label_mark">
        <xsl:with-param name="ul-numbering-index" select="$ul-numbering-index"/>
      </xsl:call-template>
    </fo:list-item-label>
    <fo:list-item-body xsl:use-attribute-sets="ul_li_body">
      <fo:block>
        <xsl:apply-templates/>
      </fo:block>
    </fo:list-item-body><xsl:text>
</xsl:text>
  </fo:list-item><xsl:text>
</xsl:text>
</xsl:template>

<xsl:attribute-set name="dl">
  <xsl:attribute name="margin-left">1.33em</xsl:attribute>
  <xsl:attribute name="margin-right">1.33em</xsl:attribute>
  <xsl:attribute name="keep-with-previous">always</xsl:attribute>
</xsl:attribute-set>

<xsl:attribute-set name="dd">
  <xsl:attribute name="margin-left">40pt</xsl:attribute>
</xsl:attribute-set>

<xsl:template match="dl">
  <fo:block xsl:use-attribute-sets="dl"
      space-before.minimum="3pt" space-before.optimum="5pt" space-before.maximum="8pt"
      space-after.minimum="3pt" space-after.optimum="5pt" space-after.maximum="8pt">
    <xsl:apply-templates/>
  </fo:block><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="dt">
  <fo:block>
    <xsl:apply-templates/>
  </fo:block><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="dd">
  <fo:block xsl:use-attribute-sets="dd">
    <xsl:apply-templates/>
  </fo:block><xsl:text>
</xsl:text>
</xsl:template>
<!-- =========================================================== -->

<xsl:template match="*" priority="-1">
  <fo:block>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

</xsl:stylesheet>
