<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns="http://www.w3.org/1999/xhtml"
>

<xsl:output method="xml"
  omit-xml-declaration="no" encoding="ISO-8859-1"/>

<xsl:param name="line-stacking-strategy">max-height</xsl:param>

<xsl:template match="/">
  <fo:root line-stacking-strategy="{$line-stacking-strategy}">
    <fo:layout-master-set>
      <fo:simple-page-master page-height="11in"
                             page-width="8.5in"
                             master-name="all-pages"
                             margin-left="1in"
                             margin-right="1in"
                             margin-top="50pt"
                             margin-bottom="50pt">
        <fo:region-body margin-bottom="25pt"
                        margin-top="25pt"/>
        <fo:region-after extent="25pt"/>
      </fo:simple-page-master>
    </fo:layout-master-set>
    <xsl:apply-templates/>
  </fo:root>
</xsl:template>

<xsl:template match="img[@src]">
  <fo:external-graphic src="{@src}">
   <xsl:if test="not(@height or @width)">
     <xsl:attribute name="width">50%</xsl:attribute>
     <xsl:attribute name="content-width">scale-to-fit</xsl:attribute>
   </xsl:if>
    <xsl:if test="@height">
      <xsl:attribute name="content-height">
        <xsl:value-of select="@height"/>px
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@width">
      <xsl:attribute name="content-width">
        <xsl:value-of select="@width"/>px
      </xsl:attribute>
    </xsl:if>
  </fo:external-graphic>
</xsl:template>

<xsl:template match="b">
  <fo:inline font-weight="bold">
    <xsl:apply-templates/>
  </fo:inline>
</xsl:template>

<xsl:template match="blockquote">
  <fo:block margin-left="2pc" margin-right="2pc" font-size="10pt" line-height="12pt"
      space-before="6pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="blockquote[@class='note']">
  <fo:block margin-left="2pc" margin-right="2pc" space-before="6pt" font-weight="bold"
    keep-with-next="always" text-align="center">NOTE:</fo:block>
  <fo:block margin-left="2pc" margin-right="2pc" 
      space-before="4pt" space-before.precedence="2"
      space-after="6pt" space-after.precedence="2">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="body">
  <fo:block space-before.minimum="3pt" space-before.optimum="12pt" 
      space-before.maximum="15pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="code">
  <fo:inline font-family="monospace" hyphenate="false">
    <xsl:apply-templates/>
  </fo:inline>
</xsl:template>

<xsl:template match="div">
  <fo:block>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="body/div/div[2]">
  <fo:block hyphenate="true" language='en'>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div[@class='abstract']">
  <fo:block font-size="12pt" line-height="12pt" font-family="sans-serif" font-weight="bold" 
      space-after="10pt" keep-with-next="always">
    <xsl:text>Abstract</xsl:text>
  </fo:block>
  <fo:block margin-left="1pc" font-size="10pt" line-height="11pt" font-family="sans-serif">
    <xsl:apply-templates/>
  </fo:block>
  <fo:block font-family="sans-serif" line-height="14pt">
    <fo:block font-weight="bold" space-before="12pt"
        space-after="10pt" keep-with-next="always">
      <xsl:text>Contents</xsl:text>
    </fo:block>
    <fo:wrapper text-align="start" text-align-last="justify">
      <xsl:apply-templates select="//div/h2|//div/h3|//div/h4" mode="toc"/>
    </fo:wrapper>
  </fo:block>
</xsl:template>

<xsl:template match="h1">
  <fo:block font-family="sans-serif" text-align="left" 
      font-weight="bold" font-size="20pt" line-height="20pt" 
      space-before.optimum="5pc" space-after.optimum="4pc">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h2">
  <fo:block font-family="sans-serif" text-align="left" 
      font-weight="bold" font-size="16pt" line-height="16pt" 
      space-before.minimum="12pt" space-before.optimum="16pt" space-before.maximum="20pt"
      space-after.minimum="10pt" space-after.optimum="12pt" space-after.maximum="16pt"
      keep-with-next="always">
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h2" mode="toc">
  <fo:block space-before="6pt" end-indent="2pc" last-line-end-indent="-2pc"
            start-indent="3pc" text-indent="-3pc">
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots"
               leader-length.minimum="15pc" leader-length.optimum="15pc"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="h3">
  <fo:block font-family="sans-serif" space-after="2pc"
      text-align="left" font-size="16pt" line-height="16pt" space-before="2pc" 
      space-before.precedence="2">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h3">
  <fo:block font-family="sans-serif" 
      text-align="left" font-weight="bold" font-size="14pt" line-height="14pt" 
      space-before.minimum="8pt" space-before.optimum="10pt" space-before.maximum="14pt"
      space-after.minimum="3pt" space-after.optimum="4pt" space-after.maximum="5pt"
      space-after.precedence="2"
      keep-with-next="always">
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h3" mode="toc">
  <fo:block space-before="3pt" end-indent="2pc" last-line-end-indent="-2pc"
            start-indent="3pc" text-indent="-3pc">
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots" 
               leader-length.minimum="15pc" leader-length.optimum="15pc"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="div/h4">
  <fo:block font-family="serif" text-align="left" 
      font-weight="bold" font-size="12pt" line-height="12pt" 
      space-before.minimum="6pt" space-before.optimum="8pt" space-before.maximum="10pt"
      space-after.minimum="3pt" space-after.optimum="4pt" space-after.maximum="5pt"
      space-after.precedence="2"
      keep-with-next="always">
    <xsl:attribute name="id">
      <xsl:text>x</xsl:text>
      <xsl:number level="multiple" count="*"/>
    </xsl:attribute>
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="div/h4" mode="toc">
  <fo:block end-indent="2pc" last-line-end-indent="-2pc"
            start-indent="3pc" text-indent="-3pc">
    <xsl:number level="multiple" count="div[not(@class) or @class != 'abstract']"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <fo:leader leader-pattern="dots"
               leader-length.minimum="15pc" leader-length.optimum="15pc"
               keep-with-previous="always" keep-with-next="always"/>
    <fo:page-number-citation>
      <xsl:attribute name="ref-id">
        <xsl:text>x</xsl:text>
        <xsl:number level="multiple" count="*"/>
      </xsl:attribute>
    </fo:page-number-citation>
  </fo:block>
</xsl:template>

<xsl:template match="head">
</xsl:template>

<xsl:template match="html">
  <fo:page-sequence master-name="all-pages" font-family="serif"
      font-size="12pt" line-height="13pt">
   <fo:static-content flow-name="xsl-region-after">
     <fo:block text-align="center">
       <fo:page-number/>
     </fo:block>
   </fo:static-content>
   <fo:flow flow-name="xsl-region-body">
    <xsl:apply-templates/>
   </fo:flow>
  </fo:page-sequence>
</xsl:template>

<xsl:template match="ol//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:number format="1."/></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ol//ol//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:number format="a."/></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ol//ol//ol//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:number format="i."/></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ol">
  <fo:list-block>
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ol//ol">
  <fo:list-block>
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ol//ol//ol">
  <fo:list-block>
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ul//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:text>&#8226;</xsl:text></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ul//ul//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:text>o</xsl:text></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ul//ul//ul//li">
  <fo:list-item space-before="3pt">
   <fo:list-item-label end-indent="label-end()">
     <fo:block text-align="end"><xsl:text>-</xsl:text></fo:block>
   </fo:list-item-label>
   <fo:list-item-body start-indent="body-start()">
    <xsl:apply-templates/>
   </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match="ul">
  <fo:list-block 
	provisional-label-separation="3pt"
	provisional-distance-between-starts="15pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ul//ul">
  <fo:list-block 
	provisional-label-separation="3pt"
	provisional-distance-between-starts="15pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="ul//ul//ul">
  <fo:list-block 
	provisional-label-separation="3pt"
	provisional-distance-between-starts="15pt">
    <xsl:apply-templates/>
  </fo:list-block>
</xsl:template>

<xsl:template match="p">
  <fo:block text-align="justify"
      space-before.minimum="4pt" space-before.optimum="6pt" space-before.maximum="8pt">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="p[@class='graphic']">
  <fo:block text-align="center"
      space-before.minimum="6pt" space-before.optimum="8pt" space-before.maximum="12pt"
      space-before.precedence="3"
      space-after.minimum="6pt" space-after.optimum="8pt" space-after.maximum="12pt"
      space-after.precedence="3">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="li/p[1]" priority="2">
  <fo:block text-align="justify">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="li/p[position()>1]" priority="1">
  <fo:block text-align="justify">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="*" priority="-1">
  <fo:block>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

</xsl:stylesheet>
